/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.LocationPattern;
import com.avaya.asm.datamgr.objectapi.LocationPatternTree;
import com.avaya.common.logging.client.Logger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocationPatternDM {
    protected final Logger log = AsmLogger.getLogger(LocationPatternDM.class);
    protected Map<Long, LocationPattern> patternMap = new HashMap<Long, LocationPattern>();
    protected LocationPatternTree ipv4PatternTree = new LocationPatternTree();
    protected LocationPatternTree ipv6PatternTree = new LocationPatternTree();
    protected Set<LocationPattern> ipv4RangeSet = new HashSet<LocationPattern>();
    protected Set<LocationPattern> ipv6RangeSet = new HashSet<LocationPattern>();
    protected List<LocationPattern> ipv4MatchList = new ArrayList<LocationPattern>();
    protected List<LocationPattern> ipv6MatchList = new ArrayList<LocationPattern>();

    public LocationPatternDM() {
    }

    public LocationPatternDM(Map<Long, LocationPattern> patternMap) {
        this.loadMaps(patternMap);
    }

    public void loadMaps(Map<Long, LocationPattern> patternMapTMP) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        this.patternMap = patternMapTMP;
        for (LocationPattern pattern : patternMapTMP.values()) {
            if (IPAddress.getAddressFamily(pattern.getIpAddressPattern()) == IPAddress.IPAddressFamily.IPV6) {
                this.insertPattern(pattern, this.ipv6RangeSet, this.ipv6MatchList, this.ipv6PatternTree);
                continue;
            }
            this.insertPattern(pattern, this.ipv4RangeSet, this.ipv4MatchList, this.ipv4PatternTree);
        }
    }

    public LocationPattern removePattern(long id) {
        LocationPattern pattern = this.patternMap.remove(id);
        if (pattern != null) {
            if (IPAddress.getAddressFamily(pattern.getIpAddressPattern()) == IPAddress.IPAddressFamily.IPV6) {
                this.deletePattern(pattern, this.ipv6RangeSet, this.ipv6MatchList, this.ipv6PatternTree);
            } else {
                this.deletePattern(pattern, this.ipv4RangeSet, this.ipv4MatchList, this.ipv4PatternTree);
            }
        }
        return pattern;
    }

    public void addPattern(long id, LocationPattern pattern) {
        if (IPAddress.getAddressFamily(pattern.getIpAddressPattern()) == IPAddress.IPAddressFamily.IPV6) {
            this.insertPattern(pattern, this.ipv6RangeSet, this.ipv6MatchList, this.ipv6PatternTree);
        } else {
            this.insertPattern(pattern, this.ipv4RangeSet, this.ipv4MatchList, this.ipv4PatternTree);
        }
        this.patternMap.put(id, pattern);
    }

    protected void insertPattern(LocationPattern pattern, Set<LocationPattern> rangeSet, List<LocationPattern> maskList, LocationPatternTree tree) {
        if (pattern.isRange()) {
            rangeSet.add(pattern);
        } else if (pattern.isMask()) {
            int index = 0;
            for (LocationPattern rop : maskList) {
                if (rop.getMaskLength() <= pattern.getMaskLength()) break;
                ++index;
            }
            maskList.add(index, pattern);
        } else {
            tree.insert(this.expandAddressPattern(pattern.getIpAddressPattern()), pattern.getLocationId());
        }
    }

    protected void deletePattern(LocationPattern pattern, Set<LocationPattern> rangeSet, List<LocationPattern> maskList, LocationPatternTree tree) {
        if (pattern.isRange()) {
            rangeSet.remove(pattern);
        } else if (pattern.isMask()) {
            maskList.remove(pattern);
        } else {
            tree.delete(this.expandAddressPattern(pattern.getIpAddressPattern()));
        }
    }

    protected String expandAddressPattern(String address) {
        IPAddress.IPAddressFamily type = IPAddress.getAddressFamily(address);
        if (type != IPAddress.IPAddressFamily.IPV6) {
            return address;
        }
        StringBuilder buf = new StringBuilder();
        String[] groups = address.split(":", -1);
        int nGroups = 0;
        int emptyGroups = 0;
        int emptyCount = 0;
        for (String group : groups) {
            if (!group.isEmpty()) continue;
            ++emptyCount;
        }
        for (String group : groups) {
            if (group.isEmpty()) {
                if (emptyGroups++ != 0) continue;
                for (int i = 0; i < 8 - groups.length + emptyCount; ++i) {
                    if (nGroups++ != 0) {
                        buf.append(":");
                    }
                    buf.append("0");
                }
                continue;
            }
            if (nGroups++ != 0) {
                buf.append(":");
            }
            buf.append(this.formatGroup(group));
        }
        return buf.toString();
    }

    protected String formatGroup(String group) {
        int i;
        int len = group.length();
        for (i = 0; i < len && group.charAt(i) == '0'; ++i) {
        }
        if (i >= len) {
            return "0";
        }
        StringBuilder buf = new StringBuilder();
        for (int j = i; j < len; ++j) {
            char c = group.charAt(j);
            if (c >= 'A' && c <= 'F') {
                c = (char)(c + 32);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public Long getMatchingLocation(String address) {
        if (address != null) {
            try {
                return this.getMatchingLocation(IPAddress.parseIPAddr(address));
            }
            catch (ParseException e) {
                this.log.warn((Object)("getMatchingLocation: bad address " + address));
            }
        }
        return null;
    }

    public Long getMatchingLocation(IPAddress address) {
        List<LocationPattern> matchList;
        Set<LocationPattern> rangeSet;
        LocationPatternTree patternTree;
        if (address.getAddressFamily() == IPAddress.IPAddressFamily.IPV6) {
            patternTree = this.ipv6PatternTree;
            rangeSet = this.ipv6RangeSet;
            matchList = this.ipv6MatchList;
        } else {
            patternTree = this.ipv4PatternTree;
            rangeSet = this.ipv4RangeSet;
            matchList = this.ipv4MatchList;
        }
        LocationPatternTree tree = patternTree.matchPattern(address);
        if (tree != null) {
            return tree.getLocationId();
        }
        for (LocationPattern pattern : rangeSet) {
            if (!pattern.matchesRange(address)) continue;
            return pattern.getLocationId();
        }
        for (LocationPattern pattern : matchList) {
            if (!pattern.matchesMask(address)) continue;
            return pattern.getLocationId();
        }
        return null;
    }

    public String[] getLocationPatternsAsArray(Long id) {
        ArrayList<String> locationPatterns = new ArrayList<String>();
        for (LocationPattern pattern : this.patternMap.values()) {
            if (pattern.getLocationId() != id.longValue()) continue;
            locationPatterns.add(pattern.getIpAddressPattern());
        }
        return locationPatterns.toArray(new String[0]);
    }

    public String getLocationPatternsAsString() {
        return "patterns: " + this.patternMap + "\nIPV4 ranges: " + this.ipv4RangeSet + "\nIPV4 masks: " + this.ipv4MatchList + "\nIPV4 tree: " + this.ipv4PatternTree.print() + "\nIPV6 ranges: " + this.ipv6RangeSet + "\nIPV6 masks: " + this.ipv6MatchList + "\nIPV6 tree: " + this.ipv6PatternTree.print();
    }

    public Map<Long, LocationPattern> getPatternMap() {
        return this.patternMap;
    }
}

