/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.CsDomainDAO;
import com.avaya.asm.datamgr.dao.CsHandleDAO;
import com.avaya.asm.datamgr.dao.PPMCsHandleDAO;
import com.avaya.asm.datamgr.dao.SIPDomainDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.dao.SetCommunityDAO;
import com.avaya.asm.datamgr.dao.UserDAO;
import com.avaya.asm.datamgr.dao.UserInfoOnDemandDAO;
import com.avaya.asm.datamgr.dao.UserSetDAO;
import com.avaya.asm.datamgr.objectapi.AsmCommProfile;
import com.avaya.asm.datamgr.objectapi.CsHandle;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.ListenPort;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.asm.datamgr.objectapi.User;
import com.avaya.common.logging.client.Logger;
import java.util.EnumSet;
import java.util.List;

public class UserInfoDM
extends BusinessLogicDM {
    private final Logger log = AsmLogger.getLogger(UserInfoDM.class);

    @Override
    public void init() {
        this.log.info((Object)"Started initializing UserInfoDM");
        DataMgr.Status status = DataMgr.Status.OKAY;
        for (uiDM dm : uiDM.values()) {
            DataMgr dataMgr = dm.get();
            if (dataMgr.okay()) continue;
            status = DataMgr.Status.FAIL;
            this.log.error((Object)("Failed to init: " + dm));
        }
        this.setStatus(status);
        this.log.info((Object)"Finished initializing UserInfoDM");
    }

    @Override
    public EnumSet<? extends BLDMEnumType> getDMUsages() {
        return EnumSet.allOf(uiDM.class);
    }

    public Long getUserIdByCommProfileSetId(Long commProfileSetId) {
        return ((UserSetDAO)uiDM.USER_SET_DAO.get()).getUserId(commProfileSetId);
    }

    @SMConsole(parameterNames={"getAnyUserByCommProfileSetId"}, description="Get the User object for the given csCommProfileSetId from any SM.")
    public User getAnyUserByCommProfileSetId(Long setId) {
        User user;
        String fcn_name = "getAnyUserByCommProfileSetId";
        Long userId = this.getUserIdByCommProfileSetId(setId);
        if (userId != null) {
            user = this.getUser(userId);
            if (user == null) {
                if (this.log.isFinestEnabled()) {
                    this.log.finest((Object)("getAnyUserByCommProfileSetId: userId " + userId + " has no local User record.  Calling the onDemandeDAO"));
                }
                user = UserInfoOnDemandDAO.getAnyUserByCommProfileSetId(setId);
            }
        } else {
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)"getAnyUserByCommProfileSetId: user not local call OnDemandDAO");
            }
            user = UserInfoOnDemandDAO.getAnyUserByCommProfileSetId(setId);
        }
        return user;
    }

    @SMConsole(parameterNames={"getUser"}, description="Get the User object for the given CsUser ID.")
    public User getUser(Long id) {
        return ((UserDAO)uiDM.USER_DAO.get()).getUser(id);
    }

    @SMConsole(parameterNames={"domain"}, description="Get the CS domain ID for the given domain.")
    public Long getCSDomainId(String domain) {
        return ((CsDomainDAO)uiDM.CS_DOMAIN_DAO.get()).getCsDomainId(domain);
    }

    @SMConsole(parameterNames={"csDomainId"}, description="Get the domain for the given CS domain ID.")
    public String getCSDomain(Long csDomainId) {
        return ((CsDomainDAO)uiDM.CS_DOMAIN_DAO.get()).getCsDomain(csDomainId);
    }

    public Long getAnyCsCommProfileSetId(String handle, Long csDomainId) {
        if (csDomainId == null) {
            return null;
        }
        CsHandle csHandle = ((PPMCsHandleDAO)uiDM.PPMCs_HANDLE_DAO.get()).getHandle(handle, csDomainId);
        if (csHandle != null) {
            return csHandle.getCsCommProfileSetId();
        }
        return null;
    }

    @SMConsole(parameterNames={"sipEntityId"}, description="Get the SIPEntity object corresponding to this Session Manager.")
    public Long getMySIPEntityId() {
        return ((AsmInstanceDAO)uiDM.ASM_INSTANCE_DAO.get()).getMySIPEntityId();
    }

    public String getAddressForSipentityId(Long sipEntityId) {
        return this.getAddressForSipentityId(IPAddress.IPAddressFamily.IPV4, sipEntityId);
    }

    public String getAddressForSipentityId(IPAddress.IPAddressFamily family, Long sipEntityId) {
        SIPEntity sipEntity = ((SIPEntityDAO)uiDM.SIP_ENTITY_DAO.get()).getSIPEntity(sipEntityId);
        if (sipEntity != null) {
            return sipEntity.getFqdnoripaddr(family);
        }
        return null;
    }

    public String getSipFqdnForSipentityId(Long sipEntityId) {
        SIPEntity sipEntity = ((SIPEntityDAO)uiDM.SIP_ENTITY_DAO.get()).getSIPEntity(sipEntityId);
        if (sipEntity != null) {
            return sipEntity.getSIPFqdn();
        }
        return null;
    }

    @SMConsole(parameterNames={"sipEntityId"}, description="Get the ListenPort objects for the given SIPEntity ID.")
    public List<ListenPort> getListenPortsForSipEntityId(Long sipEntityId) {
        return ((SIPEntityDAO)uiDM.SIP_ENTITY_DAO.get()).getListenPorts(sipEntityId);
    }

    @SMConsole(parameterNames={"sipDomainId"}, description="Get the domain for the given SIP domain ID.")
    public String getSIPDomain(Long sipDomainId) {
        return ((SIPDomainDAO)uiDM.SIP_DOMAIN_DAO.get()).getCanonicalSIPDomain(sipDomainId);
    }

    @SMConsole(parameterNames={"sipDomainId"}, description="Get the domain for the given SIP domain ID.")
    public String getActualSIPDomain(Long sipDomainId) {
        return ((SIPDomainDAO)uiDM.SIP_DOMAIN_DAO.get()).getActualSIPDomain(sipDomainId);
    }

    @SMConsole(parameterNames={"setId"}, description="Get the User Community ID for the parameter.")
    public Long getUserCommunityIdBySetId(Long setId) {
        return ((SetCommunityDAO)uiDM.SET_COMMUNITY_DAO.get()).getUserCommunityId(setId);
    }

    @SMConsole(parameterNames={"handle", "csDomainId"}, description="Get the ID of the User object corresponding to the parameters.")
    public Long getUserIdByHandle(String handle, Long csDomainId) {
        CsHandle csHandle = ((PPMCsHandleDAO)uiDM.PPMCs_HANDLE_DAO.get()).getHandle(handle, csDomainId);
        if (csHandle != null) {
            return this.getUserIdByCommProfileSetId(csHandle.getCsCommProfileSetId());
        }
        return null;
    }

    public Long getCsCommProfileSetId(String handle, Long csDomainId) {
        if (csDomainId == null) {
            return null;
        }
        CsHandle csHandle = ((PPMCsHandleDAO)uiDM.PPMCs_HANDLE_DAO.get()).getHandle(handle, csDomainId);
        if (csHandle != null) {
            return csHandle.getCsCommProfileSetId();
        }
        return null;
    }

    @SMConsole(parameterNames={"handle", "csDomainId"}, description="Get the User Community ID for the parameters.")
    public Long getUserCommunityIdByHandle(String handle, Long csDomainId) {
        CsHandle csHandle = ((PPMCsHandleDAO)uiDM.PPMCs_HANDLE_DAO.get()).getHandle(handle, csDomainId);
        if (csHandle != null) {
            return this.getUserCommunityIdBySetId(csHandle.getCsCommProfileSetId());
        }
        return null;
    }

    @SMConsole(parameterNames={"handle", "csDomainId"}, description="Get the CommProfile of the AsmUser object corresponding to the parameters.")
    public AsmCommProfile getAnyCommProfileByHandle(String handle, Long csDomainId) {
        AsmCommProfile commProfile = null;
        CsHandle csHandle = ((PPMCsHandleDAO)uiDM.PPMCs_HANDLE_DAO.get()).getHandle(handle, csDomainId);
        if (csHandle != null) {
            commProfile = this.getAnyCommProfileBySetId(csHandle.getCsCommProfileSetId());
        }
        return commProfile;
    }

    @SMConsole(parameterNames={"setId"}, description="Get the CommProfile of the CommProfileSet object corresponding to the parameters.")
    public AsmCommProfile getAnyCommProfileBySetId(long setId) {
        String fcn_name = "getAnyCommProfileBySetId";
        List<AsmCommProfile> commProfList = UserInfoOnDemandDAO.getAnyCommProfile(setId);
        AsmCommProfile commProfile = null;
        if (commProfList != null && !commProfList.isEmpty()) {
            if (commProfList.size() > 1) {
                this.log.warn((Object)("getAnyCommProfileBySetId: " + commProfList.size() + " cscommprofiles found for setId " + setId));
            }
            commProfile = commProfList.get(0);
        }
        return commProfile;
    }

    public User getUser(String loginName) {
        return ((UserDAO)uiDM.USER_DAO.get()).getUserForLoginName(loginName);
    }

    public static enum uiDM implements BLDMEnumType
    {
        ASM_INSTANCE_DAO(AsmInstanceDAO.class),
        CS_DOMAIN_DAO(CsDomainDAO.class),
        CS_HANDLE_DAO(CsHandleDAO.class),
        SET_COMMUNITY_DAO(SetCommunityDAO.class),
        SIP_DOMAIN_DAO(SIPDomainDAO.class),
        SIP_ENTITY_DAO(SIPEntityDAO.class),
        USER_DAO(UserDAO.class),
        USER_SET_DAO(UserSetDAO.class),
        PPMCs_HANDLE_DAO(PPMCsHandleDAO.class);

        private DataMgr subDM;

        private uiDM(Class<? extends DataMgr> dmClass) {
            this.subDM = DMFactory.getInstance().getDataMgr(dmClass);
        }

        @Override
        public DataMgr get() {
            return this.subDM;
        }
    }
}

