/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmAssignPolicy;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AsmAssignPolicyDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(AsmAssignPolicyDAO.class);
    protected Map<Long, AsmAssignPolicy> policyMap = new ConcurrentHashMap<Long, AsmAssignPolicy>();
    protected static final String getPolicies = "SELECT id, policy_class, policy_type FROM asm_assign_policy";
    protected static final String getPolicy = "SELECT id, policy_class, policy_type FROM asm_assign_policy WHERE id = ?";
    protected static final ResultSetMapper policyMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, AsmAssignPolicy> map = new ConcurrentHashMap<Long, AsmAssignPolicy>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                map.put(id, new AsmAssignPolicy(id, rs.getString("policy_class"), rs.getString("policy_type")));
            }
            return map;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        Map policyMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        Object[] params = new Object[]{};
        try {
            policyMapTMP = (Map)this.dataSource.executeQuery(getPolicies, params, policyMapper);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        try {
            this.lock.acquireWriteLock();
            this.setStatus(DataMgr.Status.OKAY);
            this.policyMap = policyMapTMP;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        block14: {
            operation = tableEvent.getOperation();
            tableName = tableEvent.getTableName();
            id = tableEvent.getKey();
            if (AsmAssignPolicyDAO.log.isFineEnabled()) {
                AsmAssignPolicyDAO.log.fine((Object)this.logTag(operation, tableName, id));
            }
            newPolicy = null;
            this.lock.acquireWriteLock();
            locked = true;
            try {
                params = new Object[]{id};
                if (!"asm_assign_policy".equals(tableName)) break block14;
                switch (2.$SwitchMap$com$avaya$asm$datamgr$dao$replication$DAOReplicationEvent$OperationType[operation.ordinal()]) {
                    case 1: 
                    case 2: {
                        newPolicy = (AsmAssignPolicy)((Map)this.dataSource.executeQuery("SELECT id, policy_class, policy_type FROM asm_assign_policy WHERE id = ?", params, AsmAssignPolicyDAO.policyMapper)).get(id);
                        if (newPolicy == null) ** break;
                        this.policyMap.put(id, newPolicy);
                        ** break;
lbl19:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        this.policyMap.remove(id);
                        break;
                    }
                    ** default:
lbl25:
                    // 1 sources

                    break;
                }
            }
            catch (DMException e) {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
                AsmAssignPolicyDAO.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
                this.reinit();
                if (!this.okay()) {
                    AsmAssignPolicyDAO.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                    return;
                }
            }
            finally {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
            }
        }
        if (AsmAssignPolicyDAO.log.isFineEnabled()) {
            AsmAssignPolicyDAO.log.fine((Object)(AsmAssignPolicyDAO.class.getSimpleName() + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asm_assign_policy");
        return list;
    }

    public AsmAssignPolicy getAsmAssignPolicy(Long id) {
        if (id == null) {
            return null;
        }
        try {
            this.lock.acquireReadLock();
            AsmAssignPolicy asmAssignPolicy = this.policyMap.get(id);
            return asmAssignPolicy;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all user assignment policies.")
    public Map<Long, AsmAssignPolicy> getAllAsmAssignPolicies() {
        try {
            this.lock.acquireReadLock();
            Map<Long, AsmAssignPolicy> map = Collections.unmodifiableMap(this.policyMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected Object getMainCollection() {
        return this.policyMap;
    }
}

