/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreStatementBuilder;
import com.avaya.asm.datamgr.dao.ustore.factory.UstoreDAOFactory;
import com.avaya.asm.datamgr.objectapi.CallLog;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraUtils;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class CallHistoryDAO_FP4 {
    private final Logger log = AsmLogger.getLogger(CallHistoryDAO_FP4.class);
    static final String CALLHISTORY_KEYSPACE = "callhistory";
    static final String CALLLOG_CF = "callhistory.calllog";
    static final String CALLLOGIDS_CF = "callhistory.calllogids";
    static final String GET_CALLHISTORY_QRY = "SELECT id,datetime,duration,dialog_id,local_number,number,name,type,bridged,privacy,set_id FROM callhistory.calllog";
    static final String GET_CALLLOGIDS_QRY = "SELECT ids FROM callhistory.calllogids";
    static final String ADD_CALLHISTORY_QRY = "INSERT INTO callhistory.calllog";
    static final String UPD_CALLLOGIDS_QRY = "UPDATE callhistory.calllogids SET ids=ids";
    static final String DELETE_CALLLOG_QRY = "DELETE FROM callhistory.calllog";
    static final String DELETE_CALLLOGIDS_QRY = "DELETE FROM callhistory.calllogids";
    static final String SELECT_CALLLOGIDS_QRY = "SELECT count(*) FROM callhistory.calllogids LIMIT 1000000";
    static final String SELECT_CALLLOGIDS_COMMPROF_SET_IDS = "SELECT set_id from callhistory.calllogids";
    static final String SELECT_COMMPROF_USER_IDS = "SELECT user_id from callhistory.calllogids";
    static final String SELECT_COUNT_CALLLOGIDS = "SELECT count(*) FROM calllogids";
    static volatile CallHistoryDAO_FP4 instance = null;
    static Map<Integer, CallHistoryDAO_FP4> instanceMap = new HashMap<Integer, CallHistoryDAO_FP4>();
    static Object mutex = new Object();
    static final int MAX_UUIDS_PER_SET = 5000;
    private SessionDAO sessionDAO;
    private Map<CallHistoryPSType, QueryRecord> preparedStatements = new HashMap<CallHistoryPSType, QueryRecord>();
    private static String dfltHost = null;
    private static int dfltPort = -1;
    private static String dfltUsername = null;
    private static String dfltPassword = null;

    protected CallHistoryDAO_FP4() {
    }

    public static void setConnInfo(String host, int port, String username, String password) {
        dfltHost = host;
        dfltPort = port;
        dfltUsername = username;
        dfltPassword = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CallHistoryDAO_FP4 getInstance() throws DMException {
        if (instance == null) {
            Object object = mutex;
            synchronized (object) {
                if (instance == null) {
                    CallHistoryDAO_FP4 tmpInstance;
                    instance = tmpInstance = new CallHistoryDAO_FP4(null);
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CallHistoryDAO_FP4 getInstance(Integer cassandraPort) throws DMException {
        if (cassandraPort != null) {
            CallHistoryDAO_FP4 tmpInstance = instanceMap.get(cassandraPort);
            if (tmpInstance == null) {
                Object object = mutex;
                synchronized (object) {
                    if (instanceMap.get(cassandraPort) == null) {
                        tmpInstance = new CallHistoryDAO_FP4(cassandraPort);
                        instanceMap.put(cassandraPort, tmpInstance);
                    }
                }
            }
            return tmpInstance;
        }
        return CallHistoryDAO_FP4.getInstance();
    }

    public static void setInstance(Integer cassandraPort, CallHistoryDAO_FP4 instance) {
        CallHistoryDAO_FP4.instance = instance;
        if (cassandraPort != null) {
            instanceMap.put(cassandraPort, CallHistoryDAO_FP4.instance);
        }
    }

    public CallHistoryDAO_FP4(Integer port) throws DMException {
        this.sessionDAO = UstoreDAOFactory.createSessionDAO(dfltHost, dfltPort, 8085, dfltUsername, dfltPassword, null);
        this.preparedStatements.put(CallHistoryPSType.ADD_CALLLOG, new QueryRecord("INSERT INTO callhistory.calllog (user_id,set_id,id,duration,bridged,privacy,datetime,dialog_id,local_number,number,name,type) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);", null));
        this.preparedStatements.put(CallHistoryPSType.ADD_CALLLOGIDS, new QueryRecord("UPDATE callhistory.calllogids SET ids=ids+? WHERE user_id=? AND set_id=?;", null));
        this.preparedStatements.put(CallHistoryPSType.DELETE_CALLLOG, new QueryRecord("DELETE FROM callhistory.calllog WHERE user_id=?;", null));
        this.preparedStatements.put(CallHistoryPSType.DELETE_CALLLOGIDS, new QueryRecord("DELETE FROM callhistory.calllogids WHERE user_id=?;", null));
        this.preparedStatements.put(CallHistoryPSType.DELETE_CALLLOG_SETID, new QueryRecord("DELETE FROM callhistory.calllog WHERE user_id=? AND set_id=?;", null));
        this.preparedStatements.put(CallHistoryPSType.DELETE_CALLLOGIDS_SETID, new QueryRecord("DELETE FROM callhistory.calllogids WHERE user_id=? AND set_id=?;", null));
        this.preparedStatements.put(CallHistoryPSType.DELETE_CALLLOG_SETID_ID, new QueryRecord("DELETE FROM callhistory.calllog WHERE user_id=? AND set_id=? AND id=?;", null));
        this.preparedStatements.put(CallHistoryPSType.DELETE_CALLLOGIDS_SETID_ID, new QueryRecord("UPDATE callhistory.calllogids SET ids=ids-? WHERE user_id=? AND set_id=?;", null));
        this.preparedStatements.put(CallHistoryPSType.GET_CALLLOG, new QueryRecord("SELECT id,datetime,duration,dialog_id,local_number,number,name,type,bridged,privacy,set_id FROM callhistory.calllog WHERE user_id=? AND set_id=?;", null));
        this.preparedStatements.put(CallHistoryPSType.GET_CALLLOG_FOR_USER, new QueryRecord("SELECT id,datetime,duration,dialog_id,local_number,number,name,type,bridged,privacy,set_id FROM callhistory.calllog WHERE user_id=?;", null));
        this.preparedStatements.put(CallHistoryPSType.GET_CALLLOGIDS, new QueryRecord("SELECT ids FROM callhistory.calllogids WHERE user_id=? AND set_id=?;", null));
        this.preparedStatements.put(CallHistoryPSType.GET_CALLLOGIDS_FOR_USER, new QueryRecord("SELECT ids FROM callhistory.calllogids WHERE user_id=?;", null));
        this.preparedStatements.put(CallHistoryPSType.GET_CALLLOG_LIMIT, new QueryRecord("SELECT id,datetime,duration,dialog_id,local_number,number,name,type,bridged,privacy,set_id FROM callhistory.calllog WHERE user_id=? AND set_id=? LIMIT ?;", null));
        this.preparedStatements.put(CallHistoryPSType.GET_SETID_CALLLOGIDS, new QueryRecord("SELECT set_id from callhistory.calllogids;", null));
        this.preparedStatements.put(CallHistoryPSType.GET_USERID_CALLLOGIDS, new QueryRecord("SELECT user_id from callhistory.calllogids;", null));
        this.preparedStatements.put(CallHistoryPSType.GET_USERID_COUNT_CALLLOGIDS, new QueryRecord("SELECT count(*) FROM calllogids where user_id=? AND set_id = ? ALLOW FILTERING;", null));
    }

    public List<UUID> getCallLogIds(final long csuserId, final long cscommprofilesetId) throws DMException {
        ArrayList<UUID> callLogIds = new ArrayList<UUID>();
        ResultSet rs = this.sessionDAO.executeStatement(new CallHistoryFP4StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = CallHistoryDAO_FP4.this.getPreparedStatement(CallHistoryPSType.GET_CALLLOGIDS);
                return ps.bind(new Object[]{csuserId, cscommprofilesetId});
            }
        });
        for (Row row : rs) {
            Set uuids = row.getSet("ids", UUID.class);
            callLogIds.addAll(uuids);
        }
        return callLogIds;
    }

    public List<CallLog> getCallHistory(final long csuserId, final long cscommprofilesetId, final Integer limit) throws DMException {
        ArrayList<CallLog> callLogs = new ArrayList<CallLog>();
        CallHistoryFP4StatementBuilder statementBuilder = new CallHistoryFP4StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = CallHistoryDAO_FP4.this.getPreparedStatement(limit == null ? CallHistoryPSType.GET_CALLLOG : CallHistoryPSType.GET_CALLLOG_LIMIT);
                return limit == null ? ps.bind(new Object[]{csuserId, cscommprofilesetId}) : ps.bind(new Object[]{csuserId, cscommprofilesetId, limit});
            }
        };
        ResultSet rs = this.sessionDAO.executeStatement(statementBuilder);
        for (Row row : rs) {
            CallLog callLog = this.createCallLog(row);
            callLogs.add(callLog);
        }
        return callLogs;
    }

    public Map<Long, List<CallLog>> getCallHistory(final long csuserId) throws DMException {
        List<CallLog> callLogs = new ArrayList();
        HashMap<Long, List<CallLog>> callLogsPerCommProfSetId = new HashMap<Long, List<CallLog>>();
        ResultSet rs = this.sessionDAO.executeStatement(new CallHistoryFP4StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = CallHistoryDAO_FP4.this.getPreparedStatement(CallHistoryPSType.GET_CALLLOG_FOR_USER);
                return ps.bind(new Object[]{csuserId});
            }
        });
        for (Row row : rs) {
            Long cpSetId = row.getLong("set_id");
            CallLog callLog = this.createCallLog(row);
            callLogs = (List)callLogsPerCommProfSetId.get(cpSetId);
            if (callLogs == null) {
                callLogs = new ArrayList();
                callLogsPerCommProfSetId.put(cpSetId, callLogs);
            }
            callLogs.add(callLog);
        }
        return callLogsPerCommProfSetId;
    }

    public void updateCallLogs(final long csuserId, final long cscommprofilesetId, final List<UUID> deleteList, final List<CallLog> addList) throws DMException {
        this.sessionDAO.executeStatement(new CallHistoryFP4StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                return CallHistoryDAO_FP4.this.createUpdateBatchStatement(csuserId, cscommprofilesetId, deleteList, addList);
            }
        });
    }

    private BatchStatement createUpdateBatchStatement(long csuserId, long cscommprofilesetId, List<UUID> deleteList, List<CallLog> addList) throws DMException {
        BatchStatement batch = this.getNewBatchStatement();
        if (deleteList != null) {
            this.deleteCallLogs(batch, csuserId, cscommprofilesetId, deleteList);
        }
        if (addList != null) {
            ArrayList<UUID> addUuidList = new ArrayList<UUID>(addList.size());
            PreparedStatement ps = this.getPreparedStatement(CallHistoryPSType.ADD_CALLLOG);
            for (CallLog callLog : addList) {
                this.bindAndBatchInsertCallLog(batch, ps, csuserId, cscommprofilesetId, callLog, addUuidList);
            }
            this.bindAndBatchCallLogIds(batch, addUuidList, csuserId, cscommprofilesetId, false);
        }
        return batch;
    }

    private void bindAndBatchInsertCallLog(BatchStatement batch, PreparedStatement ps, long csuserId, long cscommprofilesetId, CallLog callLog, List<UUID> addUuidList) {
        UUID timeUuid = this.genTimeUUID();
        addUuidList.add(timeUuid);
        batch.add((Statement)ps.bind(new Object[]{csuserId, cscommprofilesetId, timeUuid, callLog.getDuration(), callLog.isBridged(), callLog.isPrivacy(), new Date(callLog.getTimestamp()), callLog.getDialogId(), callLog.getLocalPartyId(), callLog.getRemotePartyId(), callLog.getRemotePartyName(), callLog.getType() != null ? callLog.getType().toString() : null}));
    }

    protected int bindAndBatchCallLogIdsByBatchSize(BatchStatement batch, PreparedStatement ps, int startIdx, List<UUID> uuidList, long csuserId, long cscommprofilesetId) {
        int batchSize = uuidList.size() - startIdx;
        if (batchSize > 5000) {
            batchSize = 5000;
        }
        HashSet<UUID> uuidSet = new HashSet<UUID>();
        for (int i = startIdx; i < startIdx + batchSize; ++i) {
            uuidSet.add(uuidList.get(i));
        }
        batch.add((Statement)ps.bind(new Object[]{uuidSet, csuserId, cscommprofilesetId}));
        return batchSize;
    }

    public void deleteAllCallLogs(long csuserId) throws DMException {
        this.doDeleteAllCallLogs(csuserId, null);
    }

    public void deleteAllCallLogsUsingSetIds(long cscommprofilesetId) throws DMException {
        this.doDeleteAllCallLogs(cscommprofilesetId, null);
    }

    public void deleteAllCallLogs(long csuserId, long cscommprofilesetId) throws DMException {
        this.doDeleteAllCallLogs(csuserId, cscommprofilesetId);
    }

    public void deleteCallLogs(final long csuserId, final long cscommprofilesetId, final List<UUID> callLogIds) throws DMException {
        BatchStatement batch = this.getNewBatchStatement();
        this.deleteCallLogs(batch, csuserId, cscommprofilesetId, callLogIds);
        this.sessionDAO.executeStatement(new CallHistoryFP4StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                BatchStatement batch = CallHistoryDAO_FP4.this.getNewBatchStatement();
                CallHistoryDAO_FP4.this.deleteCallLogs(batch, csuserId, cscommprofilesetId, callLogIds);
                return batch;
            }
        });
    }

    private void deleteCallLogs(BatchStatement batch, long csuserId, long cscommprofilesetId, List<UUID> uuidList) throws DMException {
        PreparedStatement ps = this.getPreparedStatement(CallHistoryPSType.DELETE_CALLLOG_SETID_ID);
        for (UUID id : uuidList) {
            batch.add((Statement)ps.bind(new Object[]{csuserId, cscommprofilesetId, id}));
        }
        this.bindAndBatchCallLogIds(batch, uuidList, csuserId, cscommprofilesetId, true);
    }

    private void bindAndBatchCallLogIds(BatchStatement batch, List<UUID> uuidList, long csuserId, long cscommprofilesetId, boolean deleteFlag) throws DMException {
        PreparedStatement ps = this.getPreparedStatement(deleteFlag ? CallHistoryPSType.DELETE_CALLLOGIDS_SETID_ID : CallHistoryPSType.ADD_CALLLOGIDS);
        int numUuids = uuidList.size();
        for (int startIdx = 0; startIdx < numUuids; startIdx += this.bindAndBatchCallLogIdsByBatchSize(batch, ps, startIdx, uuidList, csuserId, cscommprofilesetId)) {
        }
    }

    private void doDeleteAllCallLogs(final long csuserId, final Long cscommprofilesetId) throws DMException {
        this.sessionDAO.executeStatement(new CallHistoryFP4StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                return CallHistoryDAO_FP4.this.createDeleteAllBatchStatement(csuserId, cscommprofilesetId);
            }
        });
    }

    private BatchStatement createDeleteAllBatchStatement(long csuserId, Long cscommprofilesetId) throws DMException {
        BatchStatement batch = this.getNewBatchStatement();
        PreparedStatement ps = this.getPreparedStatement(cscommprofilesetId == null ? CallHistoryPSType.DELETE_CALLLOG : CallHistoryPSType.DELETE_CALLLOG_SETID);
        if (cscommprofilesetId != null) {
            batch.add((Statement)ps.bind(new Object[]{csuserId, cscommprofilesetId}));
        } else {
            batch.add((Statement)ps.bind(new Object[]{csuserId}));
        }
        ps = this.getPreparedStatement(cscommprofilesetId == null ? CallHistoryPSType.DELETE_CALLLOGIDS : CallHistoryPSType.DELETE_CALLLOGIDS_SETID);
        if (cscommprofilesetId != null) {
            batch.add((Statement)ps.bind(new Object[]{csuserId, cscommprofilesetId}));
        } else {
            batch.add((Statement)ps.bind(new Object[]{csuserId}));
        }
        return batch;
    }

    private CallLog createCallLog(Row row) {
        Date dateTime = row.getTimestamp("datetime");
        long timestamp = dateTime != null ? dateTime.getTime() : 0L;
        String typeStr = row.getString("type");
        CallLog.CallLogType type = typeStr == null || typeStr.isEmpty() ? CallLog.CallLogType.unknown : CallLog.CallLogType.valueOf(typeStr);
        CallLog callLog = new CallLog(row.getUUID("id"), timestamp, row.getInt("duration"), row.getString("local_number"), row.getString("number"), null, row.getString("name"), row.getString("dialog_id"), type, row.getBool("bridged"), row.getBool("privacy"));
        return callLog;
    }

    public List<Long> getCommProfSetIds() throws DMException {
        ArrayList<Long> setIdsList = new ArrayList<Long>();
        ResultSet resultSet = this.sessionDAO.executeStatement(new CallHistoryFP4StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = CallHistoryDAO_FP4.this.getPreparedStatement(CallHistoryPSType.GET_SETID_CALLLOGIDS);
                return new BoundStatement(ps);
            }
        });
        for (Row row : resultSet) {
            setIdsList.add(row.getLong("set_id"));
        }
        return setIdsList;
    }

    public List<Long> getCommProfUserIds() throws DMException {
        ArrayList<Long> userIdsList = new ArrayList<Long>();
        ResultSet resultSet = this.sessionDAO.executeStatement(new CallHistoryFP4StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = CallHistoryDAO_FP4.this.getPreparedStatement(CallHistoryPSType.GET_USERID_CALLLOGIDS);
                return new BoundStatement(ps);
            }
        });
        for (Row row : resultSet) {
            userIdsList.add(row.getLong("user_id"));
        }
        return userIdsList;
    }

    public Long getCountCallLogIds(final long csuserId, final long cscommprofilesetId) throws DMException {
        Long recordCount = 0L;
        ResultSet resultSet = this.sessionDAO.executeStatement(new CallHistoryFP4StatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = CallHistoryDAO_FP4.this.getPreparedStatement(CallHistoryPSType.GET_USERID_COUNT_CALLLOGIDS);
                return ps.bind(new Object[]{csuserId, cscommprofilesetId});
            }
        });
        for (Row row : resultSet) {
            recordCount = row.getLong(0);
        }
        return recordCount;
    }

    private PreparedStatement getPreparedStatement(CallHistoryPSType type) throws DMException {
        String fcn_name = "getPreparedStatement";
        QueryRecord queryRecord = this.preparedStatements.get((Object)type);
        if (queryRecord == null) {
            this.log.error((Object)("getPreparedStatement: no query record available for type: " + (Object)((Object)type)));
            return null;
        }
        if (queryRecord.getStatement() == null) {
            this.log.error((Object)("getPreparedStatement:  no prepared statement available for type: " + (Object)((Object)type)));
            return null;
        }
        return queryRecord.getStatement();
    }

    protected BatchStatement getNewBatchStatement() {
        return new BatchStatement();
    }

    public UUID genTimeUUID() {
        return CassandraUtils.genTimeUUID();
    }

    public static enum CallHistoryPSType {
        ADD_CALLLOG,
        ADD_CALLLOGIDS,
        DELETE_CALLLOG,
        DELETE_CALLLOGIDS,
        DELETE_CALLLOG_SETID,
        DELETE_CALLLOGIDS_SETID,
        DELETE_CALLLOG_SETID_ID,
        DELETE_CALLLOGIDS_SETID_ID,
        GET_CALLLOG,
        GET_CALLLOG_FOR_USER,
        GET_CALLLOGIDS,
        GET_CALLLOGIDS_FOR_USER,
        GET_CALLLOG_LIMIT,
        GET_SETID_CALLLOGIDS,
        GET_USERID_CALLLOGIDS,
        GET_USERID_COUNT_CALLLOGIDS;

    }

    class QueryRecord {
        final String query;
        PreparedStatement preparedStatement;

        public QueryRecord(String query, PreparedStatement ps) {
            this.query = query;
            this.preparedStatement = ps;
        }

        public synchronized PreparedStatement getStatement() throws DMException {
            if (this.preparedStatement == null) {
                this.preparedStatement = CallHistoryDAO_FP4.this.sessionDAO.prepareQuery(this.query);
            }
            return this.preparedStatement;
        }
    }

    public abstract class CallHistoryFP4StatementBuilder
    implements UserStoreStatementBuilder {
        @Override
        public abstract Statement getStatement() throws DMException;

        @Override
        public void newSession() {
        }
    }
}

