/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmerNamespacePrioDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(EmerNamespacePrioDAO.class);
    protected static final String getNameSpacePriorities = "SELECT id, namespace_priority FROM asm_emer_namespace_priority";
    protected static final String getNameSpacePriority = "SELECT namespace_priority FROM asm_emer_namespace_priority WHERE id = ?";
    private Map<Long, String> idMap = new HashMap<Long, String>();
    private Map<String, Long> namespacePriorityMap = new HashMap<String, Long>();
    protected static final ResultSetMapper namespacePriorityMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException, DMException {
            if (rs.next()) {
                return rs.getString("namespace_priority").toLowerCase();
            }
            return null;
        }
    };
    protected static final ResultSetMapper namespacePrioritiesMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException, DMException {
            ArrayList list = new ArrayList();
            HashMap<Long, String> idMap = new HashMap<Long, String>();
            HashMap<String, Long> namespacePriorityMap = new HashMap<String, Long>();
            while (rs.next()) {
                long id = rs.getLong("id");
                String name = rs.getString("namespace_priority").toLowerCase();
                idMap.put(id, name);
                namespacePriorityMap.put(name, id);
            }
            list.add(idMap);
            list.add(namespacePriorityMap);
            return list;
        }
    };

    protected ResultSetMapper getNamespacePrioritesMapper() {
        return namespacePrioritiesMapper;
    }

    protected ResultSetMapper getNamespacePriorityMapper() {
        return namespacePriorityMapper;
    }

    @Override
    protected Object getMainCollection() {
        return this.idMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + EmerNamespacePrioDAO.class.getSimpleName()));
        }
        HashMap idMapTMP = null;
        HashMap namespacePriorityMapTMP = null;
        Object[] params = new Object[]{};
        try {
            List list = (List)this.dataSource.executeQuery(getNameSpacePriorities, params, this.getNamespacePrioritesMapper());
            idMapTMP = (HashMap)list.get(0);
            namespacePriorityMapTMP = (HashMap)list.get(1);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.idMap = idMapTMP;
                this.namespacePriorityMap = namespacePriorityMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asm_emer_namespace_priority");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        Long id = tableEvent.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        String newNamespacePriority = null;
        boolean lockHeld = false;
        try {
            Object[] params;
            if (operation != DAOReplicationEvent.OperationType.DELETE && (newNamespacePriority = (String)this.dataSource.executeQuery(getNameSpacePriority, params = new Object[]{id}, this.getNamespacePriorityMapper())) != null && log.isFinerEnabled()) {
                log.fine((Object)("Retrived new Namespace priority " + newNamespacePriority));
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            String oldnamespacePriority = this.idMap.remove(id);
            if (oldnamespacePriority != null) {
                this.namespacePriorityMap.remove(oldnamespacePriority);
            }
            if (newNamespacePriority != null) {
                this.idMap.put(id, newNamespacePriority);
                this.namespacePriorityMap.put(newNamespacePriority, id);
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(EmerNamespacePrioDAO.class.getSimpleName() + " update successful"));
        }
    }

    public String getNamespacePriority(Long id) {
        try {
            this.lock.acquireReadLock();
            String string = this.idMap.get(id);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public Long getNamespacePriorityID(String namespacePriority) {
        if (namespacePriority != null) {
            try {
                this.lock.acquireReadLock();
                Long l = this.namespacePriorityMap.get(namespacePriority.toLowerCase());
                return l;
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    @SMConsole(description="Get all provisioned Namespace Priorities for NG911.")
    public Map<String, Long> getNamespacePriorityMap() {
        try {
            this.lock.acquireReadLock();
            Map<String, Long> map = Collections.unmodifiableMap(this.namespacePriorityMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned Namespace Priorites for NG911.")
    public Map<Long, String> getAllNamespacePriorities() {
        try {
            this.lock.acquireReadLock();
            Map<Long, String> map = Collections.unmodifiableMap(this.idMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

