/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.AsmLoggerUtil;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.RoutePolicy;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.Level;

public class RoutePolicyDAO
extends DataAccessObject {
    protected static final Logger log = AsmLogger.getLogger(RoutePolicyDAO.class);
    protected Map<Long, RoutePolicy> routePolicyMap = new ConcurrentHashMap<Long, RoutePolicy>();
    protected Map<Long, List<RoutePolicy>> routePolicyListMap = new ConcurrentHashMap<Long, List<RoutePolicy>>();
    protected Map<Long, RouteDigitPair> digitPolicyMap = new ConcurrentHashMap<Long, RouteDigitPair>();
    protected static final String queryDigitPolicies = "SELECT id, digitmap_id, routingpolicy_id FROM digitmaptopolicy";
    protected static final String queryDigitPolicies_id = "SELECT id, digitmap_id, routingpolicy_id FROM digitmaptopolicy WHERE id = ?";
    protected static final String queryRoutePolicies = "SELECT routingpolicy.id, sipentity_id, timezone_id, disabled, retries FROM routingpolicy LEFT OUTER JOIN sipentity  ON sipentity.id = routingpolicy.sipentity_id";
    protected static final String queryRoutePolicies_SEid = "SELECT routingpolicy.id, sipentity_id, timezone_id, disabled, retries FROM routingpolicy LEFT OUTER JOIN sipentity  ON sipentity.id = routingpolicy.sipentity_id WHERE sipentity.id = ?";
    protected static final String queryRoutePolicies_RPid = "SELECT routingpolicy.id, sipentity_id, timezone_id, disabled, retries FROM routingpolicy LEFT OUTER JOIN sipentity  ON sipentity.id = routingpolicy.sipentity_id WHERE routingpolicy.id = ?";
    protected static final ResultSetMapper routePolicyMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, RoutePolicy> map = new ConcurrentHashMap<Long, RoutePolicy>();
            while (rs.next()) {
                long id = rs.getLong("id");
                Long sipentity_id = rs.getLong("sipentity_id");
                if (sipentity_id == 0L) {
                    sipentity_id = null;
                }
                map.put(id, new RoutePolicy(id, sipentity_id, rs.getLong("timezone_id"), rs.getBoolean("disabled"), rs.getInt("retries")));
            }
            return map;
        }
    };
    protected static final ResultSetMapper digitPolicyMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, RouteDigitPair> map = new ConcurrentHashMap<Long, RouteDigitPair>();
            while (rs.next()) {
                map.put(rs.getLong("id"), new RouteDigitPair(rs.getLong("digitmap_id"), rs.getLong("routingpolicy_id")));
            }
            return map;
        }
    };

    public RoutePolicyDAO() {
        super(true);
    }

    public RoutePolicyDAO(boolean supportsListeners) {
        super(supportsListeners);
    }

    @Override
    public Object getMainCollection() {
        return null;
    }

    @Override
    public synchronized void init() {
        Map<Long, List<RoutePolicy>> routePolicyListMapTMP;
        Map digitPolicyMapTMP;
        Map routePolicyMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + RoutePolicyDAO.class.getSimpleName()));
        }
        try {
            Object[] params = new Object[]{};
            routePolicyMapTMP = (Map)this.dataSource.executeQuery(queryRoutePolicies, params, routePolicyMapper);
            digitPolicyMapTMP = (Map)this.dataSource.executeQuery(queryDigitPolicies, params, digitPolicyMapper);
            routePolicyListMapTMP = this.buildRoutePolicyListMap(routePolicyMapTMP, digitPolicyMapTMP);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            this.routePolicyMap = routePolicyMapTMP;
            this.routePolicyListMap = routePolicyListMapTMP;
            this.digitPolicyMap = digitPolicyMapTMP;
        }
    }

    protected Map<Long, List<RoutePolicy>> buildRoutePolicyListMap(Map<Long, RoutePolicy> routePolicyMap, Map<Long, RouteDigitPair> digitPolicyMap) {
        ConcurrentHashMap<Long, List<RoutePolicy>> routePolicyListMap = new ConcurrentHashMap<Long, List<RoutePolicy>>();
        for (Map.Entry<Long, RouteDigitPair> e : digitPolicyMap.entrySet()) {
            RouteDigitPair pair = e.getValue();
            long digitmap_id = pair.getDigitMapId();
            long routepolicy_id = pair.getRoutePolicyId();
            if (!routePolicyListMap.containsKey(digitmap_id)) {
                routePolicyListMap.put(digitmap_id, new CopyOnWriteArrayList());
            }
            RoutePolicy routePolicy = routePolicyMap.get(routepolicy_id);
            ((List)routePolicyListMap.get(digitmap_id)).add(routePolicy);
        }
        return routePolicyListMap;
    }

    private synchronized void updateRoutePolicyMap(String query, Long primKey, boolean isUpdate, List<Object> oldObjects, List<Object> newObjects) throws DMException {
        Object[] params = new Object[]{primKey};
        Map tmpRPMap = (Map)this.dataSource.executeQuery(query, params, routePolicyMapper);
        if (tmpRPMap.size() == 0) {
            if (query.equals(queryRoutePolicies_SEid)) {
                return;
            }
            throw new DMException("Expected at least one routepolicy, but got none.");
        }
        Set<Long> digitMapIds = this.routePolicyListMap.keySet();
        for (Map.Entry entry : tmpRPMap.entrySet()) {
            RoutePolicy oldPolicy = this.routePolicyMap.remove(entry.getKey());
            RoutePolicy newPolicy = (RoutePolicy)entry.getValue();
            if (oldPolicy == null && isUpdate) {
                throw new DMException("Tried to update with pk " + primKey + ", but entry didn't exist.");
            }
            if (oldPolicy != null && !isUpdate) {
                throw new DMException("Tried to insert with pk " + params[0] + ", but entry already existed.");
            }
            this.routePolicyMap.put((Long)entry.getKey(), newPolicy);
            if (log.isFinerEnabled()) {
                log.finer((Object)("Retrieved new RoutePolicy " + newPolicy));
            }
            oldObjects.add(oldPolicy);
            newObjects.add(newPolicy);
            if (oldPolicy == null) continue;
            for (long digitMapId : digitMapIds) {
                List<RoutePolicy> searchList = this.routePolicyListMap.get(digitMapId);
                if (!searchList.remove(oldPolicy)) continue;
                searchList.add(newPolicy);
            }
        }
    }

    @Override
    public synchronized void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)(RoutePolicyDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        Object[] params = new Object[]{id};
        ArrayList<Object> oldObjects = new ArrayList<Object>();
        ArrayList<Object> newObjects = new ArrayList<Object>();
        try {
            if (tableName.equals("sipentity")) {
                switch (operation) {
                    case UPDATE: {
                        this.updateRoutePolicyMap(queryRoutePolicies_SEid, id, true, oldObjects, newObjects);
                        break;
                    }
                    case INSERT: 
                    case DELETE: {
                        if (log.isFineEnabled()) {
                            log.fine((Object)"RoutePolicyDAO doesn't care about this update.");
                        }
                        return;
                    }
                    default: {
                        log.error((Object)("Operation type '" + (Object)((Object)operation) + "' not recognized"));
                        break;
                    }
                }
            } else if (tableName.equals("routingpolicy")) {
                switch (operation) {
                    case UPDATE: {
                        this.updateRoutePolicyMap(queryRoutePolicies_RPid, id, true, oldObjects, newObjects);
                        break;
                    }
                    case INSERT: {
                        this.updateRoutePolicyMap(queryRoutePolicies_RPid, id, false, oldObjects, newObjects);
                        break;
                    }
                    case DELETE: {
                        RoutePolicy removedRP = this.routePolicyMap.remove(id);
                        if (removedRP == null) {
                            log.warn((Object)("updateDAO: DELETE routingpolicy had a null entry in its RoutePolicyMap.  Attempt toDELETE non existing key=" + id));
                            break;
                        }
                        oldObjects.add(removedRP);
                        newObjects.add(null);
                        break;
                    }
                    default: {
                        log.error((Object)("Operation type '" + (Object)((Object)operation) + "' not recognized"));
                        break;
                    }
                }
            } else if (tableName.equals("digitmaptopolicy")) {
                switch (operation) {
                    case DELETE: {
                        newObjects.add(null);
                    }
                    case UPDATE: {
                        RouteDigitPair routeDigitPair = this.digitPolicyMap.remove(id);
                        if (routeDigitPair == null) {
                            if (operation == DAOReplicationEvent.OperationType.DELETE) {
                                log.warn((Object)("updateDAO: Provided primary key for digitmaptopolicy was null. Attempt toDELETE non existing key=" + id));
                                break;
                            }
                            log.warn((Object)("updateDAO: UPDATE digitmaptopolicy didn't have the primKey " + id));
                            break;
                        }
                        oldObjects.add(routeDigitPair);
                        long routePolicyId = routeDigitPair.getRoutePolicyId();
                        long digitMapId = routeDigitPair.getDigitMapId();
                        List<RoutePolicy> oldList = this.routePolicyListMap.get(digitMapId);
                        boolean foundOneToRemove = false;
                        for (RoutePolicy rpToRemove : oldList) {
                            if (rpToRemove.getId() != routePolicyId) continue;
                            oldList.remove(rpToRemove);
                            foundOneToRemove = true;
                            break;
                        }
                        if (!foundOneToRemove) {
                            log.warn((Object)("UPDATE digitmaptopolicy: Corrupt data, element for dig_id=" + digitMapId + ", rp_id=" + routePolicyId + " does not exist in digitPolicyMap"));
                            break;
                        }
                        if (oldList.size() == 0) {
                            this.routePolicyListMap.remove(digitMapId);
                        }
                        if (operation == DAOReplicationEvent.OperationType.DELETE) break;
                    }
                    case INSERT: {
                        Map singleDigitPolicyMap = (Map)this.dataSource.executeQuery(queryDigitPolicies_id, params, digitPolicyMapper);
                        RouteDigitPair pair = (RouteDigitPair)singleDigitPolicyMap.get(id);
                        if (pair == null) {
                            log.warn((Object)("Found no digitmaptopolicy with id " + id + " to insert"));
                            break;
                        }
                        if (operation == DAOReplicationEvent.OperationType.INSERT) {
                            oldObjects.add(null);
                        }
                        newObjects.add(pair);
                        if (log.isFinerEnabled()) {
                            log.finer((Object)("Retrieved new RouteDigitPair " + pair));
                        }
                        if (this.digitPolicyMap.containsKey(id)) {
                            log.warn((Object)("Database and DAO are out of  sync; digitPolicyMap already has primkey " + id));
                        }
                        this.digitPolicyMap.put(id, pair);
                        RoutePolicy policy = this.routePolicyMap.get(pair.getRoutePolicyId());
                        if (policy == null) {
                            log.warn((Object)("RoutePolicy with id " + pair.getRoutePolicyId() + " does not exist; Database and DAO are out of sync."));
                            break;
                        }
                        List<RoutePolicy> updatingList = this.routePolicyListMap.get(pair.getDigitMapId());
                        if (updatingList == null) {
                            updatingList = new CopyOnWriteArrayList<RoutePolicy>();
                            this.routePolicyListMap.put(pair.getDigitMapId(), updatingList);
                        }
                        if (updatingList.contains(policy)) {
                            log.warn((Object)"Out of sync, duplicate RoutePolicies exists for this list.");
                            break;
                        }
                        updatingList.add(policy);
                        break;
                    }
                }
            }
        }
        catch (DMException e) {
            log.error((Object)("Error updating " + RoutePolicyDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
            }
            return;
        }
        if (!oldObjects.isEmpty()) {
            this.updateListeners(oldObjects, newObjects);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(RoutePolicyDAO.class.getSimpleName() + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        CopyOnWriteArrayList<String> list = new CopyOnWriteArrayList<String>();
        list.add("routingpolicy");
        list.add("sipentity");
        list.add("digitmaptopolicy");
        return list;
    }

    @SMConsole(description="Get a RoutePolicy object for the given routePolicyID.")
    public RoutePolicy getRoutePolicy(Long id) {
        return this.routePolicyMap.get(id);
    }

    public Map<Long, RoutePolicy> getAllRoutePolicies() {
        return Collections.unmodifiableMap(this.routePolicyMap);
    }

    public List<RoutePolicy> getRoutePolicies(long digitMapID) {
        List<RoutePolicy> routePolicyList = this.routePolicyListMap.get(digitMapID);
        if (routePolicyList != null) {
            return Collections.unmodifiableList(routePolicyList);
        }
        return new CopyOnWriteArrayList<RoutePolicy>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getRoutePolicyIDsByEntityId(Long entityId) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (entityId == null) {
            return list;
        }
        this.lock.acquireReadLock();
        try {
            for (RoutePolicy routePolicy : this.routePolicyMap.values()) {
                if (!entityId.equals(routePolicy.getSipEntityId())) continue;
                list.add(routePolicy.getId());
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return list;
    }

    public List<RoutePolicy> getRoutePolicies(List<Long> routePolicyIDs) {
        if (routePolicyIDs == null) {
            return null;
        }
        ArrayList<RoutePolicy> routePolicyList = new ArrayList<RoutePolicy>();
        for (Long routePolicyID : routePolicyIDs) {
            routePolicyList.add(this.routePolicyMap.get(routePolicyID));
        }
        return Collections.unmodifiableList(routePolicyList);
    }

    @SMConsole(description="Get a map of DigitMap IDs to unranked lists of RoutePolicies.")
    public Map<Long, List<RoutePolicy>> getAllRoutePolicyLists() {
        return Collections.unmodifiableMap(this.routePolicyListMap);
    }

    public void setLogLevelForJUnit() {
        AsmLoggerUtil.setLogLevel(RoutePolicyDAO.class, Level.INFO);
    }

    public static class RouteDigitPair {
        private final long digitMapId;
        private final long routePolicyId;

        public RouteDigitPair(long digitMapId, long routePolicyId) {
            this.digitMapId = digitMapId;
            this.routePolicyId = routePolicyId;
        }

        public long getDigitMapId() {
            return this.digitMapId;
        }

        public long getRoutePolicyId() {
            return this.routePolicyId;
        }
    }
}

