/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.RtsApplicationSystem;
import com.avaya.asm.datamgr.objectapi.RtsApplicationSystemType;
import com.avaya.asm.datamgr.objectapi.RtsHost;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RtsHostDAO
extends DataAccessObject {
    private static final Logger log = Logger.getLogger(RtsHostDAO.class);
    List<String> dependentTables = null;
    protected Map<Long, RtsHost> rtsHostMap = new ConcurrentHashMap<Long, RtsHost>();
    protected Map<Long, RtsApplicationSystem> rtsApplicationSystemMap = new ConcurrentHashMap<Long, RtsApplicationSystem>();
    protected Map<String, Long> rtsApplicationSystemTypeMap = new ConcurrentHashMap<String, Long>();
    protected static final String byId = "WHERE id = ?";
    protected static final String selectRtsHosts = "SELECT id, address, isdeleted, ostype FROM rts_host ";
    protected static final String selectRtsApplicationSystems = "SELECT id, appsystemtypeid, displaykey, host_id, isdeleted, isregistered, name, parent_id, isgeoenabled FROM rts_applicationsystem ";
    protected static final String selectRtsApplicationSystemType = "SELECT id, name FROM rts_applicationsystemtype ";
    private static final String COLUMNNAME = "name";
    protected final ResultSetMapper rtsHostMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            RtsHost rtsHost = null;
            while (rs.next()) {
                rtsHost = new RtsHost(rs.getLong("id"), rs.getString("address"), rs.getBoolean("isdeleted"), rs.getString("ostype"));
            }
            return rtsHost;
        }
    };
    protected final ResultSetMapper allRtsHostMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, RtsHost> rtsHostMap = new HashMap<Long, RtsHost>();
            while (rs.next()) {
                long id = rs.getLong("id");
                RtsHost rtsHost = new RtsHost(id, rs.getString("address"), rs.getBoolean("isdeleted"), rs.getString("ostype"));
                rtsHostMap.put(id, rtsHost);
            }
            return rtsHostMap;
        }
    };
    protected final ResultSetMapper rtsApplicationSystemMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            RtsApplicationSystem rtsApplicationSystem = null;
            while (rs.next()) {
                rtsApplicationSystem = new RtsApplicationSystem(rs.getLong("id"), rs.getLong("appsystemtypeid"), rs.getString("displaykey"), rs.getLong("host_id"), rs.getBoolean("isdeleted"), rs.getBoolean("isregistered"), rs.getString(RtsHostDAO.COLUMNNAME), rs.getLong("parent_id"), rs.getBoolean("isgeoenabled"));
            }
            return rtsApplicationSystem;
        }
    };
    protected final ResultSetMapper allRtsApplicationSystemMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, RtsApplicationSystem> rtsApplicationSystemMap = new HashMap<Long, RtsApplicationSystem>();
            while (rs.next()) {
                long id = rs.getLong("id");
                RtsApplicationSystem rtsApplicationSystem = new RtsApplicationSystem(id, rs.getLong("appsystemtypeid"), rs.getString("displaykey"), rs.getLong("host_id"), rs.getBoolean("isdeleted"), rs.getBoolean("isregistered"), rs.getString(RtsHostDAO.COLUMNNAME), rs.getLong("parent_id"), rs.getBoolean("isgeoenabled"));
                rtsApplicationSystemMap.put(id, rtsApplicationSystem);
            }
            return rtsApplicationSystemMap;
        }
    };
    protected final ResultSetMapper allRtsApplicationSystemTypesMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<String, Long> systemTypeMap = new HashMap<String, Long>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                String name = rs.getString(RtsHostDAO.COLUMNNAME);
                systemTypeMap.put(name, id);
            }
            return systemTypeMap;
        }
    };
    protected final ResultSetMapper rtsApplicationSystemTypeMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            String systemTypeName = null;
            if (rs.next()) {
                systemTypeName = rs.getString(RtsHostDAO.COLUMNNAME);
            }
            return systemTypeName;
        }
    };

    public RtsHostDAO() {
        super(true);
        this.dependentTables = new ArrayList<String>();
        this.dependentTables.add("rts_host");
        this.dependentTables.add("rts_applicationsystem");
        this.dependentTables.add("rts_applicationsystemtype");
    }

    @Override
    protected Object getMainCollection() {
        return this.rtsHostMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        Map<Object, Object> rtsHostMapTmp = new HashMap();
        Map<Object, Object> rtsApplicationSystemMapTmp = new HashMap();
        Map<Object, Object> rtsAppSystemTypeMapTmp = new HashMap();
        rtsHostMapTmp = this.getAllRtsHosts();
        rtsApplicationSystemMapTmp = this.getAllRtsApplicationSystems();
        rtsAppSystemTypeMapTmp = this.getAllRtsAppSystemTypes();
        this.setStatus(DataMgr.Status.OKAY);
        if (this.okay()) {
            this.lock.acquireWriteLock();
            try {
                this.rtsHostMap = rtsHostMapTmp;
                this.rtsApplicationSystemMap = rtsApplicationSystemMapTmp;
                this.rtsApplicationSystemTypeMap = rtsAppSystemTypeMapTmp;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        log.info((Object)("Initializing, leave " + this.getClass().getSimpleName() + ": rtsHostMap: " + this.rtsHostMap + ": rtsApplicationSystemMap: " + this.rtsApplicationSystemMap + ": rtsApplicationSystemTypeMap:" + this.rtsApplicationSystemTypeMap));
    }

    @Override
    public List<String> getDependentTables() {
        return this.dependentTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        Long id;
        RtsApplicationSystemType newRtsAppSystemType;
        RtsApplicationSystemType oldRtsAppSystemType;
        boolean shouldUpdateListeners;
        String tableName;
        DAOReplicationEvent.OperationType operation;
        block28: {
            operation = event.getOperation();
            tableName = event.getTableName();
            shouldUpdateListeners = false;
            oldRtsAppSystemType = null;
            newRtsAppSystemType = null;
            if (!this.getDependentTables().contains(tableName) || operation == null) {
                return;
            }
            id = event.getKey();
            if (log.isFineEnabled()) {
                log.fine((Object)this.logTag(operation, tableName, id));
            }
            boolean locked = false;
            try {
                if (tableName.equals("rts_applicationsystem")) {
                    if (id != null) {
                        RtsApplicationSystem rtsApplicationSystem = this.getRtsApplicationSystem(id);
                        if (rtsApplicationSystem != null) {
                            this.lock.acquireWriteLock();
                            locked = true;
                            if (DAOReplicationEvent.OperationType.DELETE != operation) {
                                this.rtsApplicationSystemMap.put(id, rtsApplicationSystem);
                            } else {
                                this.rtsApplicationSystemMap.remove(id);
                            }
                        }
                        break block28;
                    }
                    return;
                }
                if (tableName.equals("rts_host")) {
                    if (id != null) {
                        RtsHost rtsHost = this.getRtsHost(id);
                        if (rtsHost != null) {
                            this.lock.acquireWriteLock();
                            locked = true;
                            if (DAOReplicationEvent.OperationType.DELETE != operation) {
                                this.rtsHostMap.put(id, rtsHost);
                            } else {
                                this.rtsHostMap.remove(id);
                            }
                        }
                        break block28;
                    }
                    return;
                }
                if (!tableName.equals("rts_applicationsystemtype")) break block28;
                if (id != null) {
                    String systemTypeName = this.getRtsAppSystemType(id);
                    if (systemTypeName != null) {
                        this.lock.acquireWriteLock();
                        locked = true;
                        if (DAOReplicationEvent.OperationType.DELETE != operation) {
                            this.rtsApplicationSystemTypeMap.put(systemTypeName, id);
                            shouldUpdateListeners = true;
                            newRtsAppSystemType = new RtsApplicationSystemType(id, systemTypeName);
                        } else {
                            this.rtsApplicationSystemTypeMap.remove(id);
                            shouldUpdateListeners = true;
                            oldRtsAppSystemType = new RtsApplicationSystemType(id, systemTypeName);
                        }
                        shouldUpdateListeners = false;
                    }
                    break block28;
                }
                return;
            }
            catch (Exception e) {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
                log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
                this.reinit();
                if (!this.okay()) {
                    log.error((Object)(this.logTag(operation, tableName, id) + "Update NOT successful!"));
                    return;
                }
            }
            finally {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
            }
        }
        if (shouldUpdateListeners) {
            this.updateListeners(oldRtsAppSystemType, newRtsAppSystemType);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(this.logTag(operation, tableName, id) + "Update successful"));
        }
    }

    protected RtsHost getRtsHost(Long hostId) {
        RtsHost rtsHost = null;
        try {
            Object[] params = new Object[]{hostId};
            rtsHost = (RtsHost)this.dataSource.executeQuery("SELECT id, address, isdeleted, ostype FROM rts_host WHERE id = ?", params, this.rtsHostMapper);
        }
        catch (DMException e) {
            log.error((Object)(this.getClass().getSimpleName() + ": Error getRtsHost for id = " + hostId), (Throwable)e);
        }
        return rtsHost;
    }

    protected Map<Long, RtsHost> getAllRtsHosts() {
        HashMap<Long, RtsHost> rtsHostMap = new HashMap();
        try {
            Object[] params = new Object[]{};
            rtsHostMap = (Map)this.dataSource.executeQuery(selectRtsHosts, params, this.allRtsHostMapper);
        }
        catch (DMException e) {
            log.error((Object)(this.getClass().getSimpleName() + ": Error getAllRtsHosts "), (Throwable)e);
        }
        return rtsHostMap;
    }

    protected RtsApplicationSystem getRtsApplicationSystem(Long rtsApplicationSystemId) {
        RtsApplicationSystem rtsApplicationSystem = null;
        try {
            Object[] params = new Object[]{rtsApplicationSystemId};
            rtsApplicationSystem = (RtsApplicationSystem)this.dataSource.executeQuery("SELECT id, appsystemtypeid, displaykey, host_id, isdeleted, isregistered, name, parent_id, isgeoenabled FROM rts_applicationsystem WHERE id = ?", params, this.rtsApplicationSystemMapper);
        }
        catch (DMException e) {
            log.error((Object)(this.getClass().getSimpleName() + ": Error getRtsApplicationSystems for id = " + rtsApplicationSystem), (Throwable)e);
        }
        return rtsApplicationSystem;
    }

    protected Map<Long, RtsApplicationSystem> getAllRtsApplicationSystems() {
        HashMap<Long, RtsApplicationSystem> rtsApplicationSystemMap = new HashMap();
        try {
            Object[] params = new Object[]{};
            rtsApplicationSystemMap = (Map)this.dataSource.executeQuery(selectRtsApplicationSystems, params, this.allRtsApplicationSystemMapper);
        }
        catch (DMException e) {
            log.error((Object)(this.getClass().getSimpleName() + ": Error getAllRtsApplicationSystems "), (Throwable)e);
        }
        return rtsApplicationSystemMap;
    }

    protected Map<String, Long> getAllRtsAppSystemTypes() {
        HashMap<String, Long> rtsApplicationSystemTypeMap = new HashMap();
        try {
            Object[] params = new Object[]{};
            rtsApplicationSystemTypeMap = (Map)this.dataSource.executeQuery(selectRtsApplicationSystemType, params, this.allRtsApplicationSystemTypesMapper);
        }
        catch (DMException e) {
            log.error((Object)(this.getClass().getSimpleName() + ": Error getAllRtsAppSystemTypes "), (Throwable)e);
        }
        return rtsApplicationSystemTypeMap;
    }

    protected String getRtsAppSystemType(Long id) {
        String systemTypeName = null;
        try {
            Object[] params = new Object[]{id};
            systemTypeName = (String)this.dataSource.executeQuery("SELECT id, name FROM rts_applicationsystemtype WHERE id = ?", params, this.rtsApplicationSystemTypeMapper);
        }
        catch (DMException e) {
            log.error((Object)(this.getClass().getSimpleName() + ": Error getRtsAppSystemTypef for id = " + id), (Throwable)e);
        }
        return systemTypeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAadsServerIpAddressList(Long aadsApplicationSystemId) {
        try {
            String aadsServerAddress;
            RtsHost rtsHostInstance;
            Long hostId;
            ArrayList<String> aadsServerIpAddressList = new ArrayList<String>();
            this.lock.acquireReadLock();
            RtsApplicationSystem rtsAppSystemInstance = this.rtsApplicationSystemMap.get(aadsApplicationSystemId);
            if (rtsAppSystemInstance != null && (hostId = rtsAppSystemInstance.getHostId()) != null && (rtsHostInstance = this.rtsHostMap.get(hostId)) != null && (aadsServerAddress = rtsHostInstance.getAddress()) != null && !aadsServerAddress.isEmpty()) {
                aadsServerIpAddressList.add(aadsServerAddress);
            }
            ArrayList<String> arrayList = aadsServerIpAddressList;
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(parameterNames={"rtsHostId"}, description="Get the rts_host entry based on the host id")
    public RtsHost getRtsHostMap(Long rtsHostId) {
        try {
            this.lock.acquireReadLock();
            RtsHost rtsHost = this.rtsHostMap.get(rtsHostId);
            return rtsHost;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(parameterNames={"rtsApplicationSystemId"}, description="Get the rts_applicationsystem entry based on applicationsystem id")
    public RtsApplicationSystem getRtsApplicationSystemMap(Long rtsApplicationSystemId) {
        try {
            this.lock.acquireReadLock();
            RtsApplicationSystem rtsApplicationSystem = this.rtsApplicationSystemMap.get(rtsApplicationSystemId);
            return rtsApplicationSystem;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public Long getApplicationSystemTypeId(String appName) {
        return this.rtsApplicationSystemTypeMap.get(appName);
    }

    public boolean isApplicationConfigured(Long appsystemtypeid) {
        boolean isConfigured = false;
        for (RtsApplicationSystem system : this.rtsApplicationSystemMap.values()) {
            if (!system.getAppSystemTypeId().equals(appsystemtypeid) || system.getHostId() == null) continue;
            isConfigured = true;
            break;
        }
        return isConfigured;
    }
}

