/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class BaseRangeIterator<T> {
    private InetAddress myInetAddress = null;
    private InetAddress loopbackAddress = null;
    protected String keyspace;
    protected Metadata metaData;
    protected SessionDAO sessionDAO;
    protected ProtocolVersion cqlVersion;
    public static final List<InetAddress> EMPTY_DOWN_NODES_LIST = new ArrayList<InetAddress>();
    private List<InetAddress> downNodes = null;
    private final Logger log = AsmLogger.getLogger(BaseRangeIterator.class);

    public BaseRangeIterator(SessionDAO sessionDAO, String keyspace, List<InetAddress> downNodesArg) throws UnknownHostException, DMException {
        this.init(sessionDAO, keyspace, null, downNodesArg);
    }

    public BaseRangeIterator(SessionDAO sessionDAO, String keyspace, InetAddress myInetAddressArg, List<InetAddress> downNodesArg) throws UnknownHostException, DMException {
        this.init(sessionDAO, keyspace, myInetAddressArg, downNodesArg);
    }

    private void init(SessionDAO sessionDAO, String keyspace, InetAddress myInetAddressArg, List<InetAddress> downNodesArg) throws UnknownHostException, DMException {
        String fcn_name = "init";
        boolean isFinest = this.log.isFinestEnabled();
        this.keyspace = keyspace;
        this.sessionDAO = sessionDAO;
        this.metaData = sessionDAO.getClusterMetadata();
        List<InetAddress> list = this.downNodes = downNodesArg == null ? EMPTY_DOWN_NODES_LIST : downNodesArg;
        if (myInetAddressArg == null) {
            this.myInetAddress = InetAddress.getLocalHost();
            this.loopbackAddress = InetAddress.getLocalHost();
        } else {
            this.myInetAddress = this.loopbackAddress = myInetAddressArg;
        }
        if (this.downNodes.contains(this.myInetAddress) || this.downNodes.contains(this.loopbackAddress)) {
            String msg = ": downNodes contains this Cassandra node: " + this.myInetAddress + " / " + this.loopbackAddress;
            this.log.warn((Object)("init" + msg));
            throw new DMException("init" + msg);
        }
        Configuration configuration = sessionDAO.getConfiguration();
        if (configuration == null) {
            this.cqlVersion = ProtocolVersion.V3;
            this.log.warn((Object)("init: couldn't determine the CQL version so using " + this.cqlVersion));
        } else {
            this.cqlVersion = configuration.getProtocolOptions().getProtocolVersion();
            if (isFinest) {
                this.log.finest((Object)("init: using CQL version " + this.cqlVersion));
            }
        }
    }

    protected boolean checkReplicas(Set<Host> replicas) {
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        String fcn_name = "checkReplicas";
        if (isFiner) {
            this.log.finer((Object)("checkReplicas: enter, replicas=" + replicas));
        }
        for (Host host : replicas) {
            InetAddress hostAddr = host.getEndPoint().resolve().getAddress();
            if (isFinest) {
                this.log.finest((Object)("checkReplicas: hostAddr: " + hostAddr));
            }
            if (hostAddr.equals(this.myInetAddress) || hostAddr.equals(this.loopbackAddress)) {
                if (isFiner) {
                    this.log.finer((Object)"checkReplicas: leave, returning true");
                }
                return true;
            }
            if (this.downNodes.contains(hostAddr)) continue;
            if (!isFinest) break;
            this.log.finest((Object)("checkReplicas: downNodes doesn't contain " + hostAddr));
            break;
        }
        if (isFiner) {
            this.log.finer((Object)"checkReplicas: leave, returning false");
        }
        return false;
    }

    public abstract T getNext();
}

