/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.CQLFileHandler;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.common.logging.client.Logger;
import java.util.Iterator;
import java.util.List;

public class DeviceDataKeyspaceBuilder
extends UserStoreKeyspaceBuilder {
    private static List<String> deviceCommands = null;
    private final Logger log = AsmLogger.getLogger(DeviceDataKeyspaceBuilder.class);

    public DeviceDataKeyspaceBuilder(UserStoreKeyspace keyspace) {
        super(keyspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean createColumnFamilies(SessionDAO dao) throws DMException {
        String fcn_name = "createColumnFamilies";
        if (deviceCommands == null) {
            Class<DeviceDataKeyspaceBuilder> clazz = DeviceDataKeyspaceBuilder.class;
            // MONITORENTER : com.avaya.asm.datamgr.dao.cassandra.DeviceDataKeyspaceBuilder.class
            CQLFileHandler cqlFileHandler = CQLFileHandler.getInstance();
            if (deviceCommands == null) {
                deviceCommands = cqlFileHandler.readSchema("Device.cql3");
                this.log.info((Object)(this.getClass().getName() + "." + "createColumnFamilies" + ": Read " + "Device.cql3" + " CF schema file."));
            }
            // MONITOREXIT : clazz
        }
        if (deviceCommands == null) {
            this.log.error((Object)(this.getClass().getName() + "." + "createColumnFamilies" + ": cached device commands unexpectedly null"));
            throw new DMException(this.getClass().getName() + "." + "createColumnFamilies" + ": cached device commands unexpectedly null");
        }
        List<String> ksDeviceCommands = this.getDeviceCommands();
        Iterator<String> iterator = ksDeviceCommands.iterator();
        while (iterator.hasNext()) {
            String command = iterator.next();
            dao.executeQuery(command);
        }
        return true;
    }

    public List<String> getDeviceCommands() throws DMException {
        return this.insertKeyspaceIntoCommand(deviceCommands);
    }
}

