/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.jdbc;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.jdbc.DAORequest;
import com.avaya.asm.datamgr.dao.jdbc.DAOResponse;
import com.avaya.asm.datamgr.dao.jdbc.DAOResult;
import com.avaya.asm.datamgr.dao.jdbc.DaoConnection;
import com.avaya.asm.datamgr.dao.jdbc.DaoConnectionPool;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.common.logging.client.Logger;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sql.DataSource;

public class JDBCBasedDAO {
    protected static final Logger log = AsmLogger.getLogger(JDBCBasedDAO.class);
    protected DataSource dataSource = null;
    protected DaoConnectionPool connectionPool = null;
    protected boolean cacheServerConfig = false;
    protected boolean cacheApplications = false;
    protected ExecutorService executorService = null;
    protected long queryRetries = 0L;
    protected long queryTimeout = 0L;
    protected int threadPoolSize = 0;
    protected final int DEFAULT_FETCH_SIZE = 0;

    public void setConnectionPool(DaoConnectionPool pool) throws DMException {
        this.connectionPool = pool;
        this.queryRetries = pool.getRetries();
        this.queryTimeout = pool.getQueryTimeout();
        this.threadPoolSize = pool.getPoolSize();
        if (log.isFineEnabled()) {
            log.fine((Object)("Starting thread pool with " + this.threadPoolSize + " threads"));
        }
        this.executorService = Executors.newFixedThreadPool(this.threadPoolSize);
        this.connectionPool.initializePool();
    }

    public void resetConnections() {
        this.connectionPool.reset();
    }

    public void shutdown() {
        if (log.isFineEnabled()) {
            log.fine((Object)"shutdown: Shutting down database thread pool...");
        }
        try {
            this.executorService.shutdown();
            if (log.isFinestEnabled()) {
                log.finest((Object)"shutdown: thread pool stopped, closing connection pool...");
            }
            this.connectionPool.closeAll();
            if (log.isFinestEnabled()) {
                log.finest((Object)"shutdown: shutdown complete");
            }
        }
        catch (Exception ex) {
            log.warn((Object)"shutdown: Exception shutting down thread pool", (Throwable)ex);
        }
    }

    public String getInfo() {
        return "JDBCBasedDAO " + (this.connectionPool == null ? "not set" : this.connectionPool.toString());
    }

    protected DAOResponse asyncExecuteRequest(DAORequest request) {
        return this.asyncExecuteRequest(request, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DAOResponse asyncExecuteRequest(DAORequest request, int fetchSize) {
        DAOResponse dAOResponse;
        DaoConnection conn = null;
        boolean isFinest = log.isFinestEnabled();
        long total_memory = 0L;
        long used_memory = 0L;
        long start_used_memory = 0L;
        try {
            conn = this.connectionPool.getConnection();
            if (request.getType() == DAORequest.RequestType.REQUEST_QUERY) {
                DAOResponse response;
                if (isFinest) {
                    total_memory = Runtime.getRuntime().totalMemory();
                    start_used_memory = total_memory - Runtime.getRuntime().freeMemory();
                    log.finest((Object)("asyncExecuteRequest(" + request + "," + fetchSize + "): Start recording memory usage; before chunked query, total memory is " + total_memory + ", used memory is " + start_used_memory + ", fetchSize is " + fetchSize));
                }
                Object res = conn.query(request.getRequest(), request.getParams(), request.getMapper(), fetchSize);
                if (isFinest) {
                    total_memory = Runtime.getRuntime().totalMemory();
                    used_memory = total_memory - Runtime.getRuntime().freeMemory();
                    log.finest((Object)("asyncExecuteRequest(" + request + "," + fetchSize + "): after chunked query, total memory is " + total_memory + ", Used memory is " + used_memory + ". End recording memory usage."));
                    if (used_memory - start_used_memory > 5000000L) {
                        log.finest((Object)("asyncExecuteRequest(" + request + "," + fetchSize + "): Possible candidate for chunked query"));
                    }
                }
                DAOResponse dAOResponse2 = response = new DAOResponse(res);
                return dAOResponse2;
            }
            DAOResult res = conn.executeUpdate(request.getRequest(), request.getParams());
            dAOResponse = new DAOResponse(res);
        }
        catch (DMException e) {
            DAOResponse dAOResponse3 = new DAOResponse(e);
            return dAOResponse3;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (DMException dMException) {}
            }
        }
        return dAOResponse;
    }

    public Object executeQuery(String queryStr, Object[] params, Object queryObj) throws DMException {
        return this.executeChunkedQuery(queryStr, params, queryObj, 0);
    }

    public Object executeChunkedQuery(String queryStr, Object[] params, Object queryObj, int fetchSize) throws DMException {
        return this.executeChunkedQuery(queryStr, params, queryObj, fetchSize, this.queryTimeout);
    }

    public Object executeChunkedQuery(String queryStr, Object[] params, Object queryObj, final int fetchSize, long timeoutMS) throws DMException {
        ResultSetMapper mapper = (ResultSetMapper)queryObj;
        final DAORequest request = new DAORequest(queryStr, params, mapper);
        int count = 0;
        while (true) {
            if (log.isFinestEnabled()) {
                log.finest((Object)("executeChunkedQuery(" + queryStr + "," + Arrays.toString(params) + "," + queryObj + "," + fetchSize + "): queuing request to thread pool, try #" + (count + 1)));
            }
            Future<DAOResponse> future = this.executorService.submit(new Callable<DAOResponse>(){

                @Override
                public DAOResponse call() {
                    Thread.currentThread().setName("JDBCBasedDAOExecuteChunkedQueryThread");
                    return JDBCBasedDAO.this.asyncExecuteRequest(request, fetchSize);
                }
            });
            try {
                DAOResponse response = future.get(timeoutMS, TimeUnit.MILLISECONDS);
                DMException dex = response.getException();
                if (dex != null) {
                    if ((long)count++ < this.queryRetries) {
                        if (!log.isFinestEnabled()) continue;
                        log.finest((Object)("Got " + dex + ", retrying..."));
                        continue;
                    }
                    throw dex;
                }
                return response.getResult();
            }
            catch (InterruptedException e) {
                if ((long)count++ < this.queryRetries) {
                    if (!log.isFinestEnabled()) continue;
                    log.finest((Object)("Got " + e + ", retrying..."));
                    continue;
                }
                throw new DMException("InterruptedException occurred", e);
            }
            catch (ExecutionException e) {
                if ((long)count++ < this.queryRetries) {
                    if (!log.isFinestEnabled()) continue;
                    log.finest((Object)("Got " + e + ", retrying..."));
                    continue;
                }
                log.error((Object)"Error processing request.", (Throwable)e);
                throw new DMException("ExecutionException occurred", e);
            }
            catch (TimeoutException e) {
                if ((long)count++ < this.queryRetries) {
                    if (!log.isFinestEnabled()) continue;
                    log.finest((Object)("Got " + e + ", retrying..."));
                    continue;
                }
                throw new DMException("Database timeout occurred", e);
            }
            break;
        }
    }

    public DAOResult executeUpdate(String queryStr, Object[] params) throws DMException {
        return this.executeUpdate(queryStr, params, this.queryTimeout);
    }

    public DAOResult executeUpdate(String queryStr, Object[] params, long timeoutMS) throws DMException {
        final DAORequest request = new DAORequest(queryStr, params);
        int count = 0;
        while (true) {
            if (log.isFinestEnabled()) {
                log.finest((Object)("executeUpdate(" + queryStr + "," + Arrays.toString(params) + "): queuing request to thread pool, try #" + (count + 1)));
            }
            Future<DAOResponse> future = this.executorService.submit(new Callable<DAOResponse>(){

                @Override
                public DAOResponse call() {
                    Thread.currentThread().setName("JDBCBasedDAOExecuteUpdateThread");
                    return JDBCBasedDAO.this.asyncExecuteRequest(request);
                }
            });
            try {
                DAOResponse response = future.get(timeoutMS, TimeUnit.MILLISECONDS);
                DMException dex = response.getException();
                if (dex != null) {
                    if ((long)count++ < this.queryRetries) {
                        if (log.isFinestEnabled()) {
                            log.finest((Object)("Got " + dex + ", count=" + count + ", queryRetries=" + this.queryRetries + ", timeout=" + timeoutMS + ", retrying..."));
                        }
                    } else {
                        throw dex;
                    }
                }
                return (DAOResult)response.getResult();
            }
            catch (InterruptedException e) {
                if ((long)count++ < this.queryRetries) {
                    if (!log.isFinestEnabled()) continue;
                    log.finest((Object)("Got " + e + ", count=" + count + ", queryRetries=" + this.queryRetries + ", timeout=" + timeoutMS + ", retrying..."));
                    continue;
                }
                throw new DMException("InterruptedException occured", e);
            }
            catch (ExecutionException e) {
                if ((long)count++ < this.queryRetries) {
                    if (!log.isFinestEnabled()) continue;
                    log.finest((Object)("Got " + e + ", count=" + count + ", queryRetries=" + this.queryRetries + ", timeout=" + timeoutMS + ", retrying..."));
                    continue;
                }
                throw new DMException("ExecutionException occured", e);
            }
            catch (TimeoutException e) {
                if ((long)count++ < this.queryRetries) {
                    log.info((Object)("Got " + e + ", count=" + count + ", queryRetries=" + this.queryRetries + ", timeout=" + timeoutMS + ", retrying..."));
                    continue;
                }
                throw new DMException("Database timeout occurred, retries=" + count + ", timeout=" + timeoutMS, e);
            }
            break;
        }
    }

    public void setQueryRetries(long queryRetries) {
        if (log.isFinerEnabled()) {
            log.finer((Object)("setQueryRetries: queryRetries set to " + queryRetries));
        }
        this.queryRetries = queryRetries;
    }

    public void setQueryTimeout(long queryTimeout) {
        if (log.isFinerEnabled()) {
            log.finer((Object)("setQueryTimeout: queryTimeout set to " + queryTimeout));
        }
        this.queryTimeout = queryTimeout;
    }

    public void setExecutorService(ExecutorService ex) {
        this.executorService = ex;
    }
}

