/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ppm;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.ppm.ContactListMemberDAO;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.ContactRecord;
import com.avaya.asm.datamgr.objectapi.ContactRecords;
import com.avaya.asm.datamgr.objectapi.ppm.ContactListMember;
import com.avaya.asm.datamgr.objectapi.ppm.CsContact;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContactDAO
extends IsDeletedHandler {
    private static final Logger log = AsmLogger.getLogger(ContactDAO.class);
    protected Map<Long, CsContact> publicContactMap = new HashMap<Long, CsContact>();
    private static final String selectContacts = "SELECT con.id, con.displayname, con.displaynameascii, con.preferredgivenname, con.ispublic, con.notes, con.csuserid, con.givenname, con.givennameascii,  con.surname, con.surnameascii, con.preferredlanguage, con.ispublic, con.updatedatetime  FROM cscontact con";
    private static final String localConditional = " JOIN cscontactlistmember clm ON clm.cspersonid = con.id JOIN cscontactlist cl ON cl.id = clm.cscontactlistid JOIN csuser u ON u.id = cl.csuserid JOIN cscommprofileset set ON set.csuserid = u.id JOIN cscommprofile cs ON cs.cscommprofilesetid = set.id JOIN asmcommprofile asm ON asm.id = cs.id" + (DMUtilities.isBranch() ? " WHERE u.isDeleted = false AND asm.survivability_server_id IN (SELECT sipentity_id FROM asminstance WHERE id=?)" : " JOIN asmusercommunityassign uca ON uca.asmusercommunity_id = asm.usercommunity_id WHERE u.isDeleted = false AND uca.asminstance_id = ?") + " AND con.ispublic = false";
    protected static final String getLocalContacts = "SELECT con.id, con.displayname, con.displaynameascii, con.preferredgivenname, con.ispublic, con.notes, con.csuserid, con.givenname, con.givennameascii,  con.surname, con.surnameascii, con.preferredlanguage, con.ispublic, con.updatedatetime  FROM cscontact con" + localConditional;
    protected static final String getPublicContacts = "SELECT con.id, con.displayname, con.displaynameascii, con.preferredgivenname, con.ispublic, con.notes, con.csuserid, con.givenname, con.givennameascii,  con.surname, con.surnameascii, con.preferredlanguage, con.ispublic, con.updatedatetime  FROM cscontact con WHERE con.ispublic = true";
    protected static final String getContacts = getLocalContacts + " UNION " + "SELECT con.id, con.displayname, con.displaynameascii, con.preferredgivenname, con.ispublic, con.notes, con.csuserid, con.givenname, con.givennameascii,  con.surname, con.surnameascii, con.preferredlanguage, con.ispublic, con.updatedatetime  FROM cscontact con WHERE con.ispublic = true";
    protected static final String getContact = getLocalContacts + " AND con.id = ? UNION " + "SELECT con.id, con.displayname, con.displaynameascii, con.preferredgivenname, con.ispublic, con.notes, con.csuserid, con.givenname, con.givennameascii,  con.surname, con.surnameascii, con.preferredlanguage, con.ispublic, con.updatedatetime  FROM cscontact con WHERE con.ispublic = true" + " AND con.id = ?";
    public static final String getOwnerIdFromCsContactId = "select csuserid AS id from cscontact  where id=:csContactId";
    public static final String getClmIdFromCsContactId = "select id from cscontactlistmember  where cscontactlistid =(select defaultcontactlistid from csuser where  id=(select csuserid from cscontact where id=:csContactId AND ispublic='f')) AND cscontactid=:csContactId";
    public static final String getOwnerIdFromCsPciId = " select ownerid AS id from csprivatecontactinfo  where id=:pciId";
    public static final String getClmIdFromCsPciId = " select id from cscontactlistmember  where csprivatecontactinfoid=:pciId";
    protected static final ResultSetMapper mapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, CsContact> map = new HashMap<Long, CsContact>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                map.put(id, ContactDAO.createCsContact(rs));
            }
            return map;
        }
    };

    public ContactDAO() {
        super(false);
        this.getIdsByUserId = "SELECT con.id, u.isdeleted FROM cscontact con JOIN csuser u ON con.csuserid=u.id WHERE u.id = ?";
    }

    private static CsContact createCsContact(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        boolean ispublic = rs.getBoolean("ispublic");
        Long csuserid = rs.getLong("csuserid");
        Long publicContactOwner = null;
        if (ispublic) {
            publicContactOwner = csuserid;
        }
        return new CsContact(id, rs.getString("displayname"), rs.getString("displaynameascii"), rs.getString("preferredgivenname"), rs.getString("givenname"), rs.getString("givennameascii"), rs.getString("surname"), rs.getString("surnameascii"), rs.getString("preferredlanguage"), ispublic, rs.getString("notes"), publicContactOwner, rs.getTimestamp("updatedatetime"));
    }

    protected Object[] getUpdateParams(Object id) {
        return new Object[]{DMUtilities.getLocalAsmInstanceParams()[0], id, id};
    }

    protected ContactListMemberDAO getContactListMemberDAO() {
        return (ContactListMemberDAO)this.getDataMgr(ContactListMemberDAO.class);
    }

    @Override
    protected Object getMainCollection() {
        return this.publicContactMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        Map contactMapTMP = new HashMap();
        Object[] params = new Object[]{};
        try {
            contactMapTMP = (Map)this.dataSource.executeChunkedQuery(getPublicContacts, params, mapper, 10000, 30000L);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.publicContactMap = contactMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public String getMainTable() {
        return "cscontact";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        super.updateDAO(tableEvent);
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        Long id = tableEvent.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        boolean locked = false;
        try {
            if ("cscontact".equals(tableName)) {
                Map map = (Map)this.dataSource.executeQuery(getContact, this.getUpdateParams(id), mapper);
                CsContact newContact = (CsContact)map.get(id);
                this.lock.acquireWriteLock();
                locked = true;
                if (newContact != null && newContact.isIspublic()) {
                    if (this.publicContactMap.containsKey(id)) {
                        this.publicContactMap.remove(id);
                    }
                    this.publicContactMap.put(id, newContact);
                }
            }
        }
        catch (Exception e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (log.isFinerEnabled()) {
            log.finer((Object)(ContactDAO.class.getSimpleName() + ".objectChanged: " + oldObject + " became " + newObject));
        }
        if (oldObject instanceof ContactListMember || newObject instanceof ContactListMember) {
            DAOTableEvent event;
            ContactListMember oldContactListMember = (ContactListMember)oldObject;
            ContactListMember newContactListMember = (ContactListMember)newObject;
            if (oldContactListMember != null && newContactListMember != null && oldContactListMember.getCspersonid() == newContactListMember.getCspersonid()) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(ContactDAO.class.getSimpleName() + ".objectChanged: ContactListMember CHANGED with same cspersonid - ignored"));
                }
                return;
            }
            if (oldContactListMember != null) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(ContactDAO.class.getSimpleName() + ".objectChanged: ContactListMember DELETED"));
                }
                event = new DAOTableEvent("cscontact", DAOReplicationEvent.OperationType.DELETE, oldContactListMember.getCspersonid());
                this.updateDAO(event);
            }
            if (newContactListMember != null) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(ContactDAO.class.getSimpleName() + ".objectChanged: ContactListMember ADDED"));
                }
                event = new DAOTableEvent("cscontact", DAOReplicationEvent.OperationType.INSERT, newContactListMember.getCspersonid());
                this.updateDAO(event);
            }
        } else {
            super.objectChanged(oldObject, newObject);
        }
    }

    public CsContact getCsContact(ContactRecords dbRecords, Long contactId) {
        CsContact contact = null;
        String fcn_name = "getCsContact";
        boolean isFinest = log.isFinestEnabled();
        List<ContactRecord> contactRecordList = dbRecords.getContactRecordList();
        if (isFinest) {
            log.finest((Object)("getCsContact: Searching contactId = " + contactId + " in dbRecords = " + dbRecords));
        }
        if (contactId != null) {
            for (ContactRecord record : contactRecordList) {
                Long recordId = record.getPerson_id();
                if (isFinest) {
                    log.finest((Object)("getCsContact: contactId = " + contactId + " recordId = " + recordId));
                }
                if (!contactId.equals(recordId)) continue;
                contact = this.createCsContact(record);
                if (!isFinest) break;
                log.finest((Object)("getCsContact: Found contactId = " + contactId + " csContact = " + contact));
                break;
            }
        }
        if (contact == null) {
            contact = this.publicContactMap.get(contactId);
        }
        return contact;
    }

    public Collection<Long> getPublicContactIds() {
        try {
            ArrayList<Long> list;
            this.lock.acquireReadLock();
            ArrayList<Long> arrayList = list = new ArrayList<Long>(this.publicContactMap.keySet());
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Deprecated
    public List<CsContact> getPublicContacts() {
        ArrayList<CsContact> contactList = new ArrayList<CsContact>(this.publicContactMap.values());
        return contactList;
    }

    public CsContact getPublicContact(Long contactId) {
        CsContact contact = null;
        String fcn_name = "getPublicContact";
        boolean isFinest = log.isFinestEnabled();
        CsContact publicContact = this.publicContactMap.get(contactId);
        if (publicContact != null) {
            if (isFinest) {
                log.finest((Object)("getPublicContact: Found publicContact - " + publicContact));
            }
            contact = new CsContact(publicContact);
        }
        return contact;
    }

    @SMConsole(description="Get all CsContacts which are either for local SIP Users or are public contacts.")
    public Map<Long, CsContact> getCsContacts() {
        try {
            this.lock.acquireReadLock();
            Map<Long, CsContact> map = Collections.unmodifiableMap(this.publicContactMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private CsContact createCsContact(ContactRecord record) {
        CsContact contact = new CsContact(record.getPerson_id(), record.getDisplayname(), record.getDisplaynameascii(), record.getPreferredgivenname(), record.getGivenname(), record.getGivennameascii(), record.getSurname(), record.getSurnameascii(), record.getPreferredlanguage(), record.isIspublic(), record.getContact_notes(), record.getCsuserid(), null);
        return contact;
    }

    @Override
    public int numChangesBeforeReinit() {
        return Integer.MAX_VALUE;
    }

    @SMConsole(description="Get user Id from csContactId.")
    public Long getCsUserIdFromCsContactId(Long csContactId) {
        String fcn_name = "getCsUserIdFromCsContactId";
        Long csUserId = null;
        String query = getOwnerIdFromCsContactId.replaceAll(":csContactId", Long.toString(csContactId));
        try {
            csUserId = this.executeQueryForCsUserId(query);
        }
        catch (DMException dme) {
            log.error((Object)(fcn_name + ": csContactId = " + csContactId + " Caught DMException "), (Throwable)dme);
        }
        return csUserId;
    }

    private Long executeQueryForCsUserId(String query) throws DMException {
        String fcn_name = "executeQueryForCsUserId";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        Long csUserId = null;
        if (isFinest.booleanValue()) {
            log.finest((Object)("executeQueryForCsUserId: QUERY = " + query));
        }
        Long currentTime = System.currentTimeMillis();
        csUserId = (Long)this.dataSource.executeQuery(query, params, ContactDAO.getIdMapper());
        if (isFinest.booleanValue()) {
            log.finest((Object)("executeQueryForCsUserId: Time required for query - " + query + " = " + (System.currentTimeMillis() - currentTime) + " ms."));
        }
        return csUserId;
    }

    protected static final ResultSetMapper getIdMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                Long csUserId = 0L;
                if (rs.next()) {
                    csUserId = rs.getLong("id");
                }
                return csUserId;
            }
        };
    }

    @SMConsole(description="Get contact's clmId from csContactId.")
    public Long getClmIdFromCsContactId(Long csContactId) {
        String fcn_name = "getClmIdFromCsContactId";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        Long clmId = null;
        String query = getClmIdFromCsContactId.replaceAll(":csContactId", Long.toString(csContactId));
        if (isFinest.booleanValue()) {
            log.finest((Object)("getClmIdFromCsContactId: QUERY = " + query));
        }
        try {
            Long currentTime = System.currentTimeMillis();
            clmId = (Long)this.dataSource.executeQuery(query, params, ContactDAO.getIdMapper());
            if (isFinest.booleanValue()) {
                log.finest((Object)("getClmIdFromCsContactId: Time required for getClmIdFromCsContactId query = " + (System.currentTimeMillis() - currentTime) + " ms."));
            }
        }
        catch (DMException dme) {
            log.error((Object)("getClmIdFromCsContactId: csContactId = " + csContactId + " Caught DMException "), (Throwable)dme);
        }
        return clmId;
    }

    @SMConsole(description="Get contact's ownerCsUserId from csPciId.")
    public Long getCsUserIdFromCsPciId(Long csPciId) {
        String fcn_name = "getCsUserIdFromCsPciId";
        Long csUserId = null;
        String query = getOwnerIdFromCsPciId.replaceAll(":pciId", Long.toString(csPciId));
        try {
            csUserId = this.executeQueryForCsUserId(query);
        }
        catch (DMException dme) {
            log.error((Object)(fcn_name + ": csPciId = " + csPciId + " Caught DMException "), (Throwable)dme);
        }
        return csUserId;
    }

    @SMConsole(description="Get contact's clmId from csPciId.")
    public Long getClmIdFromCsPciId(Long csPciId) {
        String fcn_name = "getClmIdFromCsPciId";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        Long clmId = null;
        String query = getClmIdFromCsPciId.replaceAll(":pciId", Long.toString(csPciId));
        if (isFinest.booleanValue()) {
            log.finest((Object)("getClmIdFromCsPciId: QUERY = " + query));
        }
        try {
            Long currentTime = System.currentTimeMillis();
            clmId = (Long)this.dataSource.executeQuery(query, params, ContactDAO.getIdMapper());
            if (isFinest.booleanValue()) {
                log.finest((Object)("getClmIdFromCsPciId: Time required for getClmIdFromCsPciId query = " + (System.currentTimeMillis() - currentTime) + " ms."));
            }
        }
        catch (DMException dme) {
            log.error((Object)("getClmIdFromCsPciId: csPciId = " + csPciId + " Caught DMException "), (Throwable)dme);
        }
        return clmId;
    }
}

