/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ppm;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.LocalAsmCommProfileDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.LocalAsmCommProfile;
import com.avaya.asm.datamgr.objectapi.ppm.AsmSipDevice;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SipDeviceDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(SipDeviceDAO.class);
    protected final String ASM_COMM_PROFILE_NAME = "asmcommprofile";
    protected Map<Long, AsmSipDevice> sipDeviceMap = new HashMap<Long, AsmSipDevice>();
    protected Map<Long, List<AsmSipDevice>> sipDeviceMapByCommprofId = new HashMap<Long, List<AsmSipDevice>>();
    protected static final String getSipDevices = "SELECT dev.id, dev.asmcommprofile_id, dev.deviceHandle, dev.updatedatetime FROM asmsipdevice dev WHERE dev.asmcommprofile_id IN (" + LocalAsmCommProfileDAO.getLocalAsmCommProfileIDs + ")";
    protected static final String getSipDevice = getSipDevices + " AND dev.id = ?";
    protected static final String getSipDevicesByAsmCommProfileId = getSipDevices + " AND dev.asmcommprofile_id = ?";
    protected static final ResultSetMapper sipDevicesMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, AsmSipDevice> map = new HashMap<Long, AsmSipDevice>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                map.put(id, new AsmSipDevice(id, rs.getLong("asmcommprofile_id"), rs.getString("deviceHandle"), rs.getTimestamp("updatedatetime")));
            }
            return map;
        }
    };
    protected static final ResultSetMapper sipDeviceMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return new AsmSipDevice(rs.getLong("id"), rs.getLong("asmcommprofile_id"), rs.getString("deviceHandle"), rs.getTimestamp("updatedatetime"));
            }
            return null;
        }
    };

    public SipDeviceDAO() {
        super(true);
    }

    protected Object[] getInitParams() {
        Long myAsmInstanceId = this.getAsmInstanceDAO().getMyInstanceId();
        return new Object[]{myAsmInstanceId == null ? 0L : myAsmInstanceId};
    }

    protected Object[] getUpdateParams(Object id) {
        Long myAsmInstanceId = this.getAsmInstanceDAO().getMyInstanceId();
        return new Object[]{myAsmInstanceId == null ? 0L : myAsmInstanceId, id};
    }

    protected LocalAsmCommProfileDAO getLocalAsmCommProfileDAO() {
        return (LocalAsmCommProfileDAO)this.getDataMgr(LocalAsmCommProfileDAO.class);
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)DMFactory.getInstance().getDataMgr(AsmInstanceDAO.class);
    }

    @Override
    protected Object getMainCollection() {
        return this.sipDeviceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        HashMap sipDeviceByIdMapTMP = new HashMap();
        HashMap<Long, List<AsmSipDevice>> sipDeviceMapByCommprofIdTMP = new HashMap<Long, List<AsmSipDevice>>();
        Object[] params = this.getInitParams();
        try {
            this.getLocalAsmCommProfileDAO();
            if (params[0] != null) {
                sipDeviceByIdMapTMP = (HashMap)this.dataSource.executeQuery(getSipDevices, params, sipDevicesMapper);
            }
            this.initializeByCommprofIdMap(sipDeviceMapByCommprofIdTMP, sipDeviceByIdMapTMP);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.sipDeviceMap = sipDeviceByIdMapTMP;
                this.sipDeviceMapByCommprofId = sipDeviceMapByCommprofIdTMP;
            }
            finally {
                this.lock.releaseWriteLock();
                log.fine((Object)(this.getClass().getSimpleName() + ": completing init"));
            }
        }
    }

    private void initializeByCommprofIdMap(Map<Long, List<AsmSipDevice>> sipDeviceMapByCommprofIdTMP, Map<Long, AsmSipDevice> sipDeviceByIdMapTMP) {
        for (AsmSipDevice sipDevice : sipDeviceByIdMapTMP.values()) {
            Long commProfId = sipDevice.getAsmcommprofile_id();
            if (!sipDeviceMapByCommprofIdTMP.containsKey(commProfId)) {
                sipDeviceMapByCommprofIdTMP.put(commProfId, new ArrayList());
            }
            sipDeviceMapByCommprofIdTMP.get(commProfId).add(sipDevice);
        }
    }

    @Override
    public DataMgr.Status reinit() {
        this.eventQueue.clear();
        this.init();
        if (!AsmCommon.jUnitEnvironment) {
            for (DMListener listener : this.getListeners()) {
                if (!(listener instanceof DataMgr)) continue;
                ((DataMgr)listener).reinit();
            }
        }
        return this.getStatus();
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmsipdevice");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        String fcn_name = SipDeviceDAO.class.getSimpleName() + ".updateDAO: ";
        boolean isFine = log.isFineEnabled();
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        if (!this.getDependentTables().contains(tableName) && !"asmcommprofile".equals(tableName) || operation == null) {
            return;
        }
        Long id = tableEvent.getKey();
        if (isFine) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        ArrayList<AsmSipDevice> addedSipDevices = new ArrayList<AsmSipDevice>();
        ArrayList<AsmSipDevice> deletedSipDevices = new ArrayList<AsmSipDevice>();
        boolean lockHeld = false;
        try {
            if ("asmsipdevice".equals(tableName)) {
                Long asmCommProfId;
                AsmSipDevice newSipDevice = null;
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    newSipDevice = (AsmSipDevice)this.dataSource.executeQuery(getSipDevice, this.getUpdateParams(id), sipDeviceMapper);
                }
                this.lock.acquireWriteLock();
                lockHeld = true;
                AsmSipDevice oldSipDevice = this.sipDeviceMap.remove(id);
                if (oldSipDevice == null) {
                    if (operation == DAOReplicationEvent.OperationType.DELETE && isFiner) {
                        log.finer((Object)(fcn_name + "Sip device was null for " + (Object)((Object)operation) + " operation; non-local user or we may be out of sync"));
                    }
                } else {
                    asmCommProfId = oldSipDevice.getAsmcommprofile_id();
                    if (asmCommProfId != null) {
                        List<AsmSipDevice> devList = this.sipDeviceMapByCommprofId.get(asmCommProfId);
                        if (devList == null) {
                            log.warn((Object)(fcn_name + "devList was null for " + (Object)((Object)operation) + " operation; we are probably out of sync"));
                        } else {
                            devList.remove(oldSipDevice);
                            if (devList.isEmpty()) {
                                this.sipDeviceMapByCommprofId.remove(asmCommProfId);
                            }
                        }
                    }
                    deletedSipDevices.add(oldSipDevice);
                }
                if (operation != DAOReplicationEvent.OperationType.DELETE && newSipDevice != null) {
                    if (isFiner) {
                        log.finer((Object)(fcn_name + "Retrieved  " + newSipDevice.toString()));
                    }
                    this.sipDeviceMap.put(id, newSipDevice);
                    asmCommProfId = newSipDevice.getAsmcommprofile_id();
                    if (asmCommProfId != null) {
                        if (!this.sipDeviceMapByCommprofId.containsKey(asmCommProfId)) {
                            this.sipDeviceMapByCommprofId.put(asmCommProfId, new ArrayList());
                        }
                        this.sipDeviceMapByCommprofId.get(asmCommProfId).add(newSipDevice);
                    }
                    addedSipDevices.add(newSipDevice);
                }
            } else if ("asmcommprofile".equals(tableName)) {
                Map devMapTMP = null;
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    Object[] params = this.getUpdateParams(id);
                    if (isFinest) {
                        log.finest((Object)(fcn_name + "Executing query:  " + getSipDevicesByAsmCommProfileId + " with params <" + Arrays.toString(params) + ">"));
                    }
                    devMapTMP = (Map)this.dataSource.executeQuery(getSipDevicesByAsmCommProfileId, params, sipDevicesMapper);
                }
                this.lock.acquireWriteLock();
                lockHeld = true;
                List<AsmSipDevice> devList = this.sipDeviceMapByCommprofId.remove(id);
                if (devList == null) {
                    if (operation == DAOReplicationEvent.OperationType.DELETE && isFiner) {
                        log.finer((Object)(fcn_name + "AsmSipDevice list was null for " + (Object)((Object)operation) + " operation; non-local user or we may be out of sync"));
                    }
                } else {
                    for (AsmSipDevice dev : devList) {
                        AsmSipDevice oldSipDevice = this.sipDeviceMap.remove(dev.getId());
                        if (oldSipDevice == null) {
                            if (operation != DAOReplicationEvent.OperationType.DELETE) continue;
                            log.warn((Object)(fcn_name + "AsmSipDevice was null for " + (Object)((Object)operation) + " operation; we are probably out of sync"));
                            continue;
                        }
                        deletedSipDevices.add(oldSipDevice);
                    }
                }
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    for (Long devId : devMapTMP.keySet()) {
                        AsmSipDevice newdevice = (AsmSipDevice)devMapTMP.get(devId);
                        this.sipDeviceMap.put(devId, newdevice);
                        if (!this.sipDeviceMapByCommprofId.containsKey(id)) {
                            this.sipDeviceMapByCommprofId.put(id, new ArrayList());
                        }
                        this.sipDeviceMapByCommprofId.get(id).add(newdevice);
                        addedSipDevices.add(newdevice);
                    }
                }
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            log.error((Object)("Error updating " + this.logTag(operation, tableName, id) + "; re-initializing. e = "), (Throwable)e);
            addedSipDevices.clear();
            deletedSipDevices.clear();
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
            if (isFine) {
                log.fine((Object)(fcn_name + " update successful"));
            }
        }
        if (deletedSipDevices.size() == 1 && addedSipDevices.size() == 1 && ((AsmSipDevice)deletedSipDevices.get(0)).getId() == ((AsmSipDevice)addedSipDevices.get(0)).getId()) {
            if (!((AsmSipDevice)deletedSipDevices.get(0)).equals(addedSipDevices.get(0))) {
                if (isFinest) {
                    log.finest((Object)(fcn_name + "calling updateListeners: oldSipDevice=" + deletedSipDevices.get(0) + " newSipDevice=" + addedSipDevices.get(0)));
                }
                this.updateListeners(deletedSipDevices.get(0), addedSipDevices.get(0));
            }
        } else {
            for (AsmSipDevice oldSipDevice : deletedSipDevices) {
                if (isFinest) {
                    log.finest((Object)(fcn_name + "calling updateListeners: oldSipDevice=" + oldSipDevice + " newSipDevice=null"));
                }
                this.updateListeners(oldSipDevice, null);
            }
            for (AsmSipDevice newSipDevice : addedSipDevices) {
                if (isFinest) {
                    log.finest((Object)(fcn_name + "calling updateListeners: oldSipDevice=null newSipDevice=" + newSipDevice));
                }
                this.updateListeners(null, newSipDevice);
            }
        }
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (log.isFinerEnabled()) {
            log.finer((Object)(SipDeviceDAO.class.getSimpleName() + ".objectChanged: " + oldObject + " became " + newObject));
        }
        if (oldObject instanceof LocalAsmCommProfile || newObject instanceof LocalAsmCommProfile) {
            DAOTableEvent event;
            LocalAsmCommProfile oldCommProfile = (LocalAsmCommProfile)oldObject;
            LocalAsmCommProfile newCommProfile = (LocalAsmCommProfile)newObject;
            if (oldCommProfile != null && newCommProfile != null && oldCommProfile.getId() == newCommProfile.getId()) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(SipDeviceDAO.class.getSimpleName() + ".objectChanged: AsmCommProfile CHANGED with same id - ignored"));
                }
                return;
            }
            if (oldCommProfile != null) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(SipDeviceDAO.class.getSimpleName() + ".objectChanged: AsmCommProfile DELETED"));
                }
                event = new DAOTableEvent("asmcommprofile", DAOReplicationEvent.OperationType.DELETE, oldCommProfile.getId());
                this.updateDAO(event);
            }
            if (newCommProfile != null) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(SipDeviceDAO.class.getSimpleName() + ".objectChanged: AsmCommProfile ADDED"));
                }
                event = new DAOTableEvent("asmcommprofile", DAOReplicationEvent.OperationType.INSERT, newCommProfile.getId());
                this.updateDAO(event);
            }
        } else {
            super.objectChanged(oldObject, newObject);
        }
    }

    public AsmSipDevice getSipDeviceById(Long id) {
        if (id != null) {
            try {
                this.lock.acquireReadLock();
                AsmSipDevice asmSipDevice = this.sipDeviceMap.get(id);
                return asmSipDevice;
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsmSipDevice> getDevices(Long asmCommProfId) {
        if (asmCommProfId != null) {
            try {
                this.lock.acquireReadLock();
                List<AsmSipDevice> originalDeviceList = this.sipDeviceMapByCommprofId.get(asmCommProfId);
                if (originalDeviceList != null) {
                    ArrayList<AsmSipDevice> arrayList = new ArrayList<AsmSipDevice>(originalDeviceList);
                    return arrayList;
                }
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsmSipDevice getDeviceByName(Long asmCommProfId, String name) {
        block6: {
            if (name != null && asmCommProfId != null) {
                try {
                    this.lock.acquireReadLock();
                    List<AsmSipDevice> sipDevicesList = this.sipDeviceMapByCommprofId.get(asmCommProfId);
                    if (sipDevicesList == null) break block6;
                    for (AsmSipDevice sipDevice : sipDevicesList) {
                        if (!name.equals(sipDevice.getDeviceHandle())) continue;
                        AsmSipDevice asmSipDevice = sipDevice;
                        return asmSipDevice;
                    }
                }
                finally {
                    this.lock.releaseReadLock();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsmSipDevice> getDevicesByFamily(long asmCommProfId, String familyName) {
        ArrayList<AsmSipDevice> usersDevicesForSpecificFamily = new ArrayList<AsmSipDevice>();
        try {
            this.lock.acquireReadLock();
            List<AsmSipDevice> sipDevicesList = this.sipDeviceMapByCommprofId.get(asmCommProfId);
            if (sipDevicesList != null) {
                for (AsmSipDevice sipDevice : sipDevicesList) {
                    if (!sipDevice.getDeviceHandle().startsWith(familyName)) continue;
                    usersDevicesForSpecificFamily.add(sipDevice);
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return usersDevicesForSpecificFamily;
    }

    @SMConsole(description="Get the contents of all internal storage related to AsmSipDevices. This method exists for debugging the SipDeviceDAO.")
    public String getSipDevices() {
        try {
            this.lock.acquireReadLock();
            String string = this.stringify();
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get Map containing data keyed by asmsipdevice.id")
    public Map<Long, AsmSipDevice> getSipDevicesById() {
        try {
            this.lock.acquireReadLock();
            Map<Long, AsmSipDevice> map = Collections.unmodifiableMap(this.sipDeviceMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get Map containing data keyed by asmcommprofile.id vs. asmsipdevice.id")
    public Map<Long, List<AsmSipDevice>> getSipDevicesByCommProfileId() {
        try {
            this.lock.acquireReadLock();
            Map<Long, List<AsmSipDevice>> map = Collections.unmodifiableMap(this.sipDeviceMapByCommprofId);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get the number of entries in the main device Map")
    public int getSipDeviceCount() {
        try {
            this.lock.acquireReadLock();
            int n = this.sipDeviceMap.size();
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private String stringify() {
        StringBuilder retString = new StringBuilder();
        retString.append("sipDeviceMap (AsmSipDevice ID to AsmSipDevice objects) - local, ");
        retString.append(this.sipDeviceMap.size());
        retString.append(" entries\n");
        for (Map.Entry<Long, AsmSipDevice> entry : this.sipDeviceMap.entrySet()) {
            retString.append(entry).append("\n");
        }
        retString.append("\n");
        retString.append("sipDeviceMapByCommprofId (AsmCommProfile ID to List of AsmSipDevice objects) - local, ");
        retString.append(this.sipDeviceMapByCommprofId.size()).append(" entries\n");
        for (Map.Entry<Long, Object> entry : this.sipDeviceMapByCommprofId.entrySet()) {
            retString.append(entry.getKey()).append(":\n");
            for (AsmSipDevice dev : (List)entry.getValue()) {
                retString.append(dev).append("\n");
            }
        }
        return retString.toString();
    }
}

