/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.replication;

import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import java.util.HashMap;
import java.util.Map;

public class DAOTableEvent {
    private String tableName;
    private DAOReplicationEvent.OperationType operation;
    private long key;
    private String objKey = null;
    private Map<String, String> tblEventData;

    public DAOTableEvent(DAOReplicationEvent evt) {
        this.tableName = evt.getPrimaryTable();
        this.operation = evt.getOperation();
        this.objKey = evt.getPrimaryKey();
        try {
            this.key = Long.parseLong(this.objKey);
        }
        catch (NumberFormatException e) {
            this.key = -1L;
        }
        this.tblEventData = new HashMap<String, String>(evt.getEventData());
    }

    public DAOTableEvent(String tableName, DAOReplicationEvent.OperationType operation, long key) {
        this.tableName = tableName;
        this.operation = operation;
        this.objKey = Long.valueOf(key).toString();
        this.key = key;
        this.tblEventData = new HashMap<String, String>();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public DAOReplicationEvent.OperationType getOperation() {
        return this.operation;
    }

    public void setOperation(DAOReplicationEvent.OperationType operation) {
        this.operation = operation;
    }

    public long getKey() {
        return this.key;
    }

    public void setKey(long key) {
        this.key = key;
        this.objKey = "" + key;
    }

    public Object getObjKey() {
        return this.objKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.key ^ this.key >>> 32);
        result = 31 * result + (this.objKey == null ? 0 : this.objKey.hashCode());
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DAOTableEvent other = (DAOTableEvent)obj;
        if (this.key != other.key) {
            return false;
        }
        if (this.objKey == null ? other.objKey != null : !this.objKey.equals(other.objKey)) {
            return false;
        }
        if (this.operation != other.operation) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }

    public String toString() {
        return "DAOTableEvent[tableName=" + this.tableName + ", operation=" + (Object)((Object)this.operation) + ", key=" + this.key + "]";
    }

    public String getTblEventtDataEntry(String repColName) {
        return this.tblEventData.get(repColName);
    }

    public Map<String, String> getTblEventData() {
        return this.tblEventData;
    }
}

