/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ustore.factory;

import com.avaya.asm.core.AES;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.CassandraBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraSSLOptions;
import com.avaya.ustore.UStoreCommonConstants;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.DecoderException;

public class UstoreDAOFactory {
    private static final Logger log = AsmLogger.getLogger(UstoreDAOFactory.class);
    public static final int DFLT_CQL_PORT = UStoreCommonConstants.CASSANDRA_CLIENT_TLS ? UStoreCommonConstants.CASSANDRA_CQL_PORT_SSL : UStoreCommonConstants.CASSANDRA_CQL_PORT;
    public static final int DFLT_JMX_PORT = UStoreCommonConstants.CASSANDRA_JMX_PORT;
    private static final String DFLT_USER = "5754504c3562796e6f6657754f57586c6230637578513d3d";
    private static final String DFLT_PASSWD = "6c436b54662f355938674930674e7a496a41547363413d3d";
    public static String DFLT_HOST = UStoreCommonConstants.CASSANDRA_CQL_HOST;
    public static AES aes = new AES();
    protected static Object mutex;
    protected static Map<HostPortKey, CassandraBasedDAO> cbdInstanceMap;
    protected static SessionDAOFactoryMap sdFactoryMap;
    protected static Map<HostPortKey, CassandraSSLOptions> dfltSSLOptions;

    public static void setDfltSSLOptions(String host, int port, CassandraSSLOptions sslOptions) {
        HostPortKey hpk = new HostPortKey(host, port);
        dfltSSLOptions.put(hpk, sslOptions);
    }

    public static void setDfltSSLOptions(CassandraSSLOptions sslOptions) {
        UstoreDAOFactory.setDfltSSLOptions(DFLT_HOST, DFLT_CQL_PORT, sslOptions);
    }

    public static CassandraSSLOptions getDfltSSLOptions(String host, int port) {
        HostPortKey hpk = new HostPortKey(host, port);
        return dfltSSLOptions.get(hpk);
    }

    public static CassandraSSLOptions getDfltSSLOptions() {
        return UstoreDAOFactory.getDfltSSLOptions(DFLT_HOST, DFLT_CQL_PORT);
    }

    public static SessionDAO createSessionDAO(String host, int port, int jmxPort, String dbUsername, String dbPassword, String keyspace) {
        HostPortKey hpk = new HostPortKey(host, port);
        return UstoreDAOFactory.createSessionDAO(host, port, jmxPort, dbUsername, dbPassword, keyspace, dfltSSLOptions.get(hpk));
    }

    public static SessionDAO createSessionDAO(String host, int port, int jmxPort, String dbUsername, String dbPassword, String keyspace, CassandraSSLOptions sslOptions) {
        KeyspaceHostPortKey khpk = new KeyspaceHostPortKey(keyspace, host, port);
        return (SessionDAO)sdFactoryMap.createValue(khpk, jmxPort, dbUsername, dbPassword, sslOptions);
    }

    public static SessionDAO createSessionDAO(String host, int port, int jmxPort, String dbUsername, String dbPassword, String keyspace, CassandraConnectionInfo.ConnectionManagementPolicy connMgmtPolicy) {
        KeyspaceHostPortKey khpk = new KeyspaceHostPortKey(keyspace, host, port, connMgmtPolicy);
        return (SessionDAO)sdFactoryMap.createValue(khpk, jmxPort, dbUsername, dbPassword, dfltSSLOptions.get(khpk));
    }

    public static SessionDAO createSessionDAO() {
        return UstoreDAOFactory.createSessionDAO(DFLT_HOST, DFLT_CQL_PORT, DFLT_JMX_PORT, UstoreDAOFactory.getDfltUserName(), UstoreDAOFactory.getDfltPassword(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CassandraBasedDAO createCassandraBasedDAO(String host, int port, int jmxPort, String dbUsername, String dbPassword) throws DMException {
        CassandraConnectionInfo.ConnectionManagementPolicy connMgmtPolicy = CassandraConnectionInfo.DEFAULT_CONNECTION_MGMT_POLICY;
        HostPortKey hpk = new HostPortKey(host, port, connMgmtPolicy);
        Object object = mutex;
        synchronized (object) {
            return UstoreDAOFactory.createCassandraBasedDAO_unlocked(host, port, jmxPort, dbUsername, dbPassword, dfltSSLOptions.get(hpk), connMgmtPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CassandraBasedDAO createCassandraBasedDAO(String host, int port, int jmxPort, String dbUsername, String dbPassword, CassandraConnectionInfo.ConnectionManagementPolicy connMgmtPolicy) throws DMException {
        HostPortKey hpk = new HostPortKey(host, port, connMgmtPolicy);
        Object object = mutex;
        synchronized (object) {
            return UstoreDAOFactory.createCassandraBasedDAO_unlocked(host, port, jmxPort, dbUsername, dbPassword, dfltSSLOptions.get(hpk), connMgmtPolicy);
        }
    }

    public static CassandraBasedDAO createCassandraBasedDAO(CassandraConnectionInfo.ConnectionManagementPolicy connMgmtPolicy) throws DMException {
        return UstoreDAOFactory.createCassandraBasedDAO(DFLT_HOST, DFLT_CQL_PORT, DFLT_JMX_PORT, UstoreDAOFactory.getDfltUserName(), UstoreDAOFactory.getDfltPassword(), connMgmtPolicy);
    }

    public static CassandraBasedDAO createCassandraBasedDAO() throws DMException {
        return UstoreDAOFactory.createCassandraBasedDAO(DFLT_HOST, DFLT_CQL_PORT, DFLT_JMX_PORT, UstoreDAOFactory.getDfltUserName(), UstoreDAOFactory.getDfltPassword(), null);
    }

    private static CassandraBasedDAO createCassandraBasedDAO_unlocked(String host, int port, int jmxPort, String dbUsername, String dbPassword, CassandraSSLOptions sslOptions, CassandraConnectionInfo.ConnectionManagementPolicy connMgmtPolicy) throws DMException {
        CassandraBasedDAO tmpCbDAOInstance = null;
        HostPortKey hpKey = new HostPortKey(host, port, connMgmtPolicy);
        tmpCbDAOInstance = cbdInstanceMap.get(hpKey);
        if (tmpCbDAOInstance == null) {
            if (sslOptions == null) {
                sslOptions = UstoreDAOFactory.getDfltSSLOptions(host, port);
            }
            tmpCbDAOInstance = new CassandraBasedDAO(new CassandraConnectionInfo(host, port, jmxPort, sslOptions, connMgmtPolicy), dbUsername, dbPassword);
            cbdInstanceMap.put(hpKey, tmpCbDAOInstance);
        }
        return tmpCbDAOInstance;
    }

    private static String getDfltUserName() {
        String fcn_name = "getDfltUserName";
        String dfltUser = null;
        try {
            dfltUser = aes.decrypt(DFLT_USER);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | DecoderException e) {
            log.error((Object)"getDfltUserName: error decrypting username", e);
        }
        return dfltUser;
    }

    private static String getDfltPassword() {
        String fcn_name = "getDfltPassword";
        String dfltPasswd = null;
        try {
            dfltPasswd = aes.decrypt(DFLT_PASSWD);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | DecoderException e) {
            log.error((Object)"getDfltPassword: error decrypting password", e);
        }
        return dfltPasswd;
    }

    static {
        String fcn_name = "UstoreDAOFactory.static";
        if (DFLT_HOST == null) {
            try {
                DFLT_HOST = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                log.error((Object)"UstoreDAOFactory.static: UnknownHostException generated getting local host", (Throwable)e);
            }
        }
        mutex = new Object();
        cbdInstanceMap = new HashMap<HostPortKey, CassandraBasedDAO>();
        sdFactoryMap = new SessionDAOFactoryMap();
        dfltSSLOptions = new HashMap<HostPortKey, CassandraSSLOptions>();
    }

    protected static class SessionDAOFactoryMap
    extends FactoryMap<KeyspaceHostPortKey, SessionDAO> {
        @Override
        protected SessionDAO newValue(CassandraBasedDAO cbd, KeyspaceHostPortKey key) throws DMException {
            SessionDAO sessionDAO = new SessionDAO(cbd, key.getKeyspace());
            return sessionDAO;
        }
    }

    protected static abstract class FactoryMap<K extends HostPortKey, V> {
        Map<K, V> instanceMap = new HashMap();

        protected FactoryMap() {
        }

        protected abstract V newValue(CassandraBasedDAO var1, K var2) throws DMException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V createValue(K hpKey, int jmxPort, String dbUsername, String dbPassword, CassandraSSLOptions sslOptions) {
            Object valueInstance;
            block11: {
                int port;
                String fcn_name = "createValue";
                String host = ((HostPortKey)hpKey).getHost();
                if (host == null) {
                    host = DFLT_HOST;
                    ((HostPortKey)hpKey).setHost(host);
                }
                if ((port = ((HostPortKey)hpKey).getPort()) < 0 || port > 65535) {
                    port = DFLT_CQL_PORT;
                    ((HostPortKey)hpKey).setPort(port);
                }
                if (jmxPort < 0 || jmxPort > 65535) {
                    jmxPort = DFLT_JMX_PORT;
                }
                if (dbUsername == null) {
                    dbUsername = UstoreDAOFactory.getDfltUserName();
                }
                if (dbPassword == null) {
                    dbPassword = UstoreDAOFactory.getDfltPassword();
                }
                valueInstance = null;
                try {
                    valueInstance = this.instanceMap.get(hpKey);
                    if (valueInstance != null) break block11;
                    Object object = mutex;
                    synchronized (object) {
                        valueInstance = this.instanceMap.get(hpKey);
                        if (valueInstance == null) {
                            CassandraBasedDAO tmpCbDAOInstance = UstoreDAOFactory.createCassandraBasedDAO_unlocked(host, port, jmxPort, dbUsername, dbPassword, sslOptions, ((HostPortKey)hpKey).getConnMgmtPolicy());
                            valueInstance = this.newValue(tmpCbDAOInstance, hpKey);
                            this.instanceMap.put(hpKey, valueInstance);
                        }
                    }
                }
                catch (DMException dme) {
                    log.error((Object)(fcn_name + ": Exception while creating the SessionDAO or the CassandraBasedDAO objects, exception= " + dme));
                }
            }
            return valueInstance;
        }
    }

    private static class KeyspaceHostPortKey
    extends HostPortKey {
        protected String keyspace;

        public KeyspaceHostPortKey(String keyspace, String host, int port) {
            super(host, port);
            this.keyspace = keyspace == null ? null : keyspace.toLowerCase();
        }

        public KeyspaceHostPortKey(String keyspace, String host, int port, CassandraConnectionInfo.ConnectionManagementPolicy connMgmtPolicy) {
            super(host, port, connMgmtPolicy);
            this.keyspace = keyspace == null ? null : keyspace.toLowerCase();
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.keyspace == null ? 0 : this.keyspace.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyspaceHostPortKey other = (KeyspaceHostPortKey)obj;
            return !(this.keyspace == null ? other.keyspace != null : !this.keyspace.equals(other.keyspace));
        }
    }

    public static class HostPortKey {
        protected String host;
        protected int port;
        protected CassandraConnectionInfo.ConnectionManagementPolicy connMgmtPolicy = CassandraConnectionInfo.DEFAULT_CONNECTION_MGMT_POLICY;

        public HostPortKey(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public HostPortKey(String host, int port, CassandraConnectionInfo.ConnectionManagementPolicy connMgmtPolicy) {
            this.host = host;
            this.port = port;
            if (connMgmtPolicy != null) {
                this.connMgmtPolicy = connMgmtPolicy;
            }
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public CassandraConnectionInfo.ConnectionManagementPolicy getConnMgmtPolicy() {
            return this.connMgmtPolicy;
        }

        public void setConnMgmtPolicy(CassandraConnectionInfo.ConnectionManagementPolicy connMgmtPolicy) {
            this.connMgmtPolicy = connMgmtPolicy;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connMgmtPolicy == null ? 0 : this.connMgmtPolicy.hashCode());
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HostPortKey other = (HostPortKey)obj;
            if (this.connMgmtPolicy != other.connMgmtPolicy) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            return this.port == other.port;
        }
    }
}

