/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.datadistributionlayer.CustomObjectInputStream;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.objectapi.WeakHashSet;
import com.avaya.common.logging.client.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;

public class JGroupEncoderDecoder {
    private static final Logger log = AsmLogger.getLogger(JGroupEncoderDecoder.class);
    private static int NUM_STREAMS = 3;
    private static int DISCARD_SIZE = 0x500000;
    private static ArrayBlockingQueue<ByteArrayOutputStream> outByteStreams = new ArrayBlockingQueue(NUM_STREAMS);
    protected static Set<ClassLoader> classLoaders;
    protected static Set<ClassLoader> replacedClassLoaders;

    public static byte[] encodeObject(Object o) throws Exception {
        byte[] byteAry = JGroupEncoderDecoder.encodeObjectToSerialized(o);
        if (log.isFinestEnabled() && (double)byteAry.length > Math.pow(1000.0, 3.0) && o instanceof DataDistLayerMessage) {
            log.finest((Object)("ENCODE: Size: " + byteAry.length + " MessageType=" + ((DataDistLayerMessage)o).getMessageType() + " AppId=" + (Object)((Object)((DataDistLayerMessage)o).getAppId())));
        }
        return byteAry;
    }

    public static Object decodeObject(byte[] buffer) throws Exception {
        Object o = JGroupEncoderDecoder.decodeObjectFromSerialized(buffer);
        if (log.isFinestEnabled() && buffer != null && (double)buffer.length > Math.pow(1000.0, 3.0) && o instanceof DataDistLayerMessage) {
            log.finest((Object)("DECODE: Size: " + buffer.length + " MessageType=" + ((DataDistLayerMessage)o).getMessageType() + " AppId=" + (Object)((Object)((DataDistLayerMessage)o).getAppId())));
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] encodeObjectToSerialized(Object o) throws IOException {
        ByteArrayOutputStream bos = null;
        byte[] byteArry = new byte[]{};
        try {
            bos = outByteStreams.take();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            Object object = o;
            synchronized (object) {
                out.writeObject(o);
            }
            out.close();
            byteArry = bos.toByteArray();
        }
        catch (InterruptedException e) {
            log.error((Object)"Interrupted!", (Throwable)e);
        }
        finally {
            if (bos != null) {
                if (bos.size() > DISCARD_SIZE) {
                    if (log.isFinerEnabled()) {
                        log.finer((Object)("Stream is larger than " + DISCARD_SIZE + " bytes.  Creating new one for the pool."));
                    }
                    bos = new ByteArrayOutputStream();
                } else {
                    bos.reset();
                }
                outByteStreams.add(bos);
            } else {
                log.warn((Object)"Byte stream is null, cannot add back to queue!");
            }
        }
        return byteArry;
    }

    private static Object decodeObjectFromSerialized(byte[] buffer) throws ClassNotFoundException, IOException {
        CustomObjectInputStream in = new CustomObjectInputStream(new ByteArrayInputStream(buffer), JGroupEncoderDecoder.getApplicationClassLoaders());
        Object o = in.readObject();
        in.close();
        return o;
    }

    protected static synchronized void mergeClassLoaders(ClassLoader otherCL) {
        WeakHashSet<ClassLoader> tmpCLSet = new WeakHashSet<ClassLoader>();
        ClassLoader newCL = otherCL;
        ClassLoader remCL = null;
        tmpCLSet.addAll(classLoaders);
        block0: for (ClassLoader curCL : tmpCLSet) {
            if (newCL == null) break;
            if (otherCL.equals(curCL)) {
                newCL = null;
                break;
            }
            ClassLoader clParent = curCL;
            while ((clParent = clParent.getParent()) != null) {
                if (!otherCL.equals(clParent)) continue;
                newCL = null;
                break;
            }
            clParent = otherCL;
            while ((clParent = clParent.getParent()) != null) {
                if (!curCL.equals(clParent)) continue;
                remCL = curCL;
                newCL = otherCL;
                if (!log.isFinerEnabled()) continue block0;
                log.finer((Object)("mergeClassLoaders: This classloader is a child of a loaded one, replace it: Existing(parent)=" + DMUtilities.getSimpleClassLoaderName(curCL) + " Other(child)=" + DMUtilities.getSimpleClassLoaderName(otherCL)));
                continue block0;
            }
        }
        if (remCL != null) {
            if (log.isFineEnabled()) {
                log.fine((Object)("mergeClassLoaders: Removing parent CL=" + DMUtilities.getSimpleClassLoaderName(remCL)));
            }
            replacedClassLoaders.add(remCL);
            tmpCLSet.remove(remCL);
        }
        if (newCL != null) {
            if (log.isFineEnabled()) {
                log.fine((Object)("mergeClassLoaders: New application CL=" + DMUtilities.getSimpleClassLoaderName(newCL)));
            }
            tmpCLSet.add(newCL);
        }
        classLoaders = tmpCLSet;
    }

    protected static synchronized void removeClassLoader(ClassLoader rmCl) {
        WeakHashSet<ClassLoader> tmpCLSet = new WeakHashSet<ClassLoader>();
        tmpCLSet.addAll(classLoaders);
        if (tmpCLSet.remove(rmCl)) {
            log.info((Object)("Removed deserialization classloader: " + DMUtilities.getSimpleClassLoaderName(rmCl)));
        }
        classLoaders = tmpCLSet;
    }

    protected static void destroy() {
        classLoaders.clear();
    }

    public static Set<ClassLoader> getApplicationClassLoaders() {
        if (classLoaders.size() == 0) {
            classLoaders.addAll(replacedClassLoaders);
        }
        return Collections.unmodifiableSet(classLoaders);
    }

    static {
        for (int i = 0; i < NUM_STREAMS; ++i) {
            outByteStreams.add(new ByteArrayOutputStream());
        }
        classLoaders = new WeakHashSet<ClassLoader>();
        replacedClassLoaders = new WeakHashSet<ClassLoader>();
    }
}

