/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;

public class TempFileResponseWrapper
implements Serializable {
    private static Logger log = AsmLogger.getLogger(TempFileResponseWrapper.class);
    private static final long serialVersionUID = -1093912012907341145L;
    private static final String TEMP_FILE_PREFIX = "DDLPyld";
    private static final String TEMP_FILE_SUFFIX = ".tmp";
    private Object payload = null;
    private File tempFile = null;

    public TempFileResponseWrapper(Object payload) {
        this.payload = payload;
    }

    public TempFileResponseWrapper toTempFile() throws IOException {
        if (this.payload == null) {
            return null;
        }
        ObjectOutputStream writer = null;
        try {
            try {
                this.tempFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
                try {
                    Files.setPosixFilePermissions(this.tempFile.toPath(), PosixFilePermissions.fromString("rw-rw-rw-"));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                writer = new ObjectOutputStream(new FileOutputStream(this.tempFile));
                writer.writeObject(this.payload);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"caught exception creating temp file", (Throwable)e);
            throw e;
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("using temp file: " + this.tempFile.toString()));
        }
        this.payload = null;
        return this;
    }

    public Object fromTempFile() throws FileNotFoundException, IOException, ClassNotFoundException {
        Object object;
        block11: {
            if (this.tempFile == null) {
                return null;
            }
            ObjectInputStream reader = null;
            try {
                reader = new ObjectInputStream(new FileInputStream(this.tempFile));
                object = reader.readObject();
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (this.tempFile != null) {
                        if (log.isFinestEnabled()) {
                            log.finest((Object)("deleting temp file: " + this.tempFile.toString()));
                        }
                        this.tempFile.delete();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error((Object)"caught exception deserializing temp file", (Throwable)e);
                    throw e;
                }
            }
            reader.close();
        }
        if (this.tempFile != null) {
            if (log.isFinestEnabled()) {
                log.finest((Object)("deleting temp file: " + this.tempFile.toString()));
            }
            this.tempFile.delete();
        }
        return object;
    }
}

