/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.CacAccessElementLocation;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacAccessElementData
implements Serializable {
    private static final long serialVersionUID = 1683814426009150795L;
    private Long timeStamp = 0L;
    private Long expiration = Long.MAX_VALUE;
    private Object uniqueKey = null;
    private Map<Long, CacAccessElementLocation> data = null;
    private Map<Integer, Map<Long, CacAccessElementLocation>> prioData = null;

    public CacAccessElementData() {
        this.timeStamp = System.currentTimeMillis();
        this.data = new ConcurrentHashMap<Long, CacAccessElementLocation>(16, 0.8f, 1);
        this.prioData = new ConcurrentHashMap<Integer, Map<Long, CacAccessElementLocation>>(5, 0.8f, 1);
    }

    public CacAccessElementData(Map<Long, CacAccessElementLocation> data, Map<Integer, Map<Long, CacAccessElementLocation>> prioData) {
        this.timeStamp = System.currentTimeMillis();
        this.data = data;
        this.prioData = prioData;
    }

    public Object getUniqueKey() {
        return this.uniqueKey;
    }

    public void setUniqueKey(Object uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public Map<Long, CacAccessElementLocation> getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, CacAccessElementLocation> getData(Integer priority) {
        if (priority == 0) {
            return this.data;
        }
        Map<Long, CacAccessElementLocation> map = this.prioData.get(priority);
        if (map == null) {
            CacAccessElementData cacAccessElementData = this;
            synchronized (cacAccessElementData) {
                map = this.prioData.get(priority);
                if (map == null) {
                    map = new ConcurrentHashMap<Long, CacAccessElementLocation>(16, 0.8f, 1);
                    this.prioData.put(priority, map);
                }
            }
        }
        return map;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uniqueKey == null ? 0 : this.uniqueKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacAccessElementData)) {
            return false;
        }
        CacAccessElementData other = (CacAccessElementData)obj;
        return !(this.uniqueKey == null ? other.uniqueKey != null : !this.uniqueKey.equals(other.uniqueKey));
    }

    public String toString() {
        String time = new Date(this.expiration).toString();
        return CacAccessElementData.class.getSimpleName() + "[Expiring at " + time + ", data is " + this.data + "]";
    }
}

