/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmSettings;
import com.avaya.asm.datamgr.objectapi.AudioVideoPool;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacBandwidthInUse
implements Serializable {
    private static final long serialVersionUID = 368090538566960838L;
    private transient Long timeStamp = System.currentTimeMillis();
    private Map<Long, AudioVideoPool> data = null;

    public CacBandwidthInUse() {
        this.data = new ConcurrentHashMap<Long, AudioVideoPool>(16, 0.8f, 1);
    }

    public CacBandwidthInUse(Map<Long, ?> data) {
        this.data = data;
    }

    public Long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Long expirationTimeDelay() {
        return AsmSettings.getConnectionPreservedTime() - (System.currentTimeMillis() - this.timeStamp) + 10000L;
    }

    public Map<Long, AudioVideoPool> getData() {
        return this.data;
    }

    public void setData(Map<Long, AudioVideoPool> data) {
        this.data = data;
    }

    public String toString() {
        String time = "now";
        if (this.timeStamp != null) {
            time = new Date(this.timeStamp).toString();
        }
        return CacBandwidthInUse.class.getSimpleName() + "[As of " + time + ", data is " + this.data + "]";
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.timeStamp = System.currentTimeMillis();
    }
}

