/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import java.text.SimpleDateFormat;
import java.util.UUID;

public class CallLog {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected UUID uuid;
    protected long timestamp;
    protected int duration;
    protected String localPartyId;
    protected String remotePartyId;
    protected String remotePartyAvExt;
    protected String remotePartyName;
    protected String dialogId;
    protected CallLogType type;
    protected boolean bridged;
    protected boolean privacy;
    protected Boolean isGlobalMigrated;

    public CallLog() {
        this(null, 0L, 0, null, null, null, null, null, CallLogType.unknown, false, false);
    }

    public CallLog(UUID uuid, long timestamp, int duration, String localPartyId, String remotePartyId, String remotePartyAvExt, String remotePartyName, String dialogId, CallLogType type, boolean bridged, boolean privacy) {
        this.uuid = uuid;
        this.timestamp = timestamp;
        this.duration = duration;
        this.localPartyId = localPartyId;
        this.remotePartyId = remotePartyId;
        this.remotePartyAvExt = remotePartyAvExt;
        this.remotePartyName = remotePartyName;
        this.dialogId = dialogId;
        this.type = type;
        this.bridged = bridged;
        this.privacy = privacy;
    }

    public CallLog(UUID uuid, long timestamp, int duration, String localPartyId, String remotePartyId, String remotePartyAvExt, String remotePartyName, String dialogId, CallLogType type, boolean bridged, boolean privacy, Boolean isGlobalMigrated) {
        this.uuid = uuid;
        this.timestamp = timestamp;
        this.duration = duration;
        this.localPartyId = localPartyId;
        this.remotePartyId = remotePartyId;
        this.remotePartyAvExt = remotePartyAvExt;
        this.remotePartyName = remotePartyName;
        this.dialogId = dialogId;
        this.type = type;
        this.bridged = bridged;
        this.privacy = privacy;
        this.isGlobalMigrated = isGlobalMigrated;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public String getLocalPartyId() {
        return this.localPartyId;
    }

    public void setLocalPartyId(String localPartyId) {
        this.localPartyId = localPartyId;
    }

    public String getRemotePartyId() {
        return this.remotePartyId;
    }

    public void setRemotePartyId(String remotePartyId) {
        this.remotePartyId = remotePartyId;
    }

    public String getRemotePartyAvExt() {
        return this.remotePartyAvExt;
    }

    public void setRemotePartyAvExt(String remotePartyAvExt) {
        this.remotePartyAvExt = remotePartyAvExt;
    }

    public String getRemotePartyName() {
        return this.remotePartyName;
    }

    public void setRemotePartyName(String remotePartyName) {
        this.remotePartyName = remotePartyName;
    }

    public String getDialogId() {
        return this.dialogId;
    }

    public void setDialogId(String dialogId) {
        this.dialogId = dialogId;
    }

    public CallLogType getType() {
        return this.type;
    }

    public void setType(CallLogType type) {
        this.type = type;
    }

    public boolean isBridged() {
        return this.bridged;
    }

    public void setBridged(boolean bridged) {
        this.bridged = bridged;
    }

    public boolean isPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(boolean privacy) {
        this.privacy = privacy;
    }

    public Boolean isGlobalMigrated() {
        return this.isGlobalMigrated;
    }

    public void setGlobalMigrated(Boolean isGlobalMigrated) {
        this.isGlobalMigrated = isGlobalMigrated;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bridged ? 1231 : 1237);
        result = 31 * result + (this.dialogId == null ? 0 : this.dialogId.hashCode());
        result = 31 * result + this.duration;
        result = 31 * result + (this.localPartyId == null ? 0 : this.localPartyId.hashCode());
        result = 31 * result + (this.privacy ? 1231 : 1237);
        result = 31 * result + (this.remotePartyAvExt == null ? 0 : this.remotePartyAvExt.hashCode());
        result = 31 * result + (this.remotePartyId == null ? 0 : this.remotePartyId.hashCode());
        result = 31 * result + (this.remotePartyName == null ? 0 : this.remotePartyName.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        result = 31 * result + (this.isGlobalMigrated != false ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallLog other = (CallLog)obj;
        if (this.bridged != other.bridged) {
            return false;
        }
        if (this.dialogId == null ? other.dialogId != null : !this.dialogId.equals(other.dialogId)) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        if (this.localPartyId == null ? other.localPartyId != null : !this.localPartyId.equals(other.localPartyId)) {
            return false;
        }
        if (this.privacy != other.privacy) {
            return false;
        }
        if (this.remotePartyAvExt == null ? other.remotePartyAvExt != null : !this.remotePartyAvExt.equals(other.remotePartyAvExt)) {
            return false;
        }
        if (this.remotePartyId == null ? other.remotePartyId != null : !this.remotePartyId.equals(other.remotePartyId)) {
            return false;
        }
        if (this.remotePartyName == null ? other.remotePartyName != null : !this.remotePartyName.equals(other.remotePartyName)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid)) {
            return false;
        }
        return this.isGlobalMigrated == other.isGlobalMigrated;
    }

    public boolean isDuplicateCallLogByFieldEquality(Object obj) {
        boolean allFieldsEqual = true;
        boolean dialogIdFieldsEqual = false;
        boolean numberFieldsEqual = false;
        boolean oneDialogIdIsNull = false;
        boolean typeFieldsEqual = true;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallLog other = (CallLog)obj;
        if (this.bridged != other.bridged) {
            allFieldsEqual = false;
        }
        if (this.dialogId == null) {
            if (other.dialogId != null) {
                allFieldsEqual = false;
                oneDialogIdIsNull = true;
            }
        } else if (other.dialogId != null) {
            if (!this.dialogId.equals(other.dialogId)) {
                allFieldsEqual = false;
            } else {
                dialogIdFieldsEqual = true;
            }
        } else {
            oneDialogIdIsNull = true;
            allFieldsEqual = false;
        }
        if (this.duration != other.duration) {
            allFieldsEqual = false;
        }
        if (this.localPartyId == null) {
            if (other.localPartyId != null) {
                allFieldsEqual = false;
            }
        } else if (!this.localPartyId.equals(other.localPartyId)) {
            allFieldsEqual = false;
        }
        if (this.privacy != other.privacy) {
            allFieldsEqual = false;
        }
        if (this.remotePartyAvExt == null) {
            if (other.remotePartyAvExt != null) {
                allFieldsEqual = false;
            }
        } else if (!this.remotePartyAvExt.equals(other.remotePartyAvExt)) {
            allFieldsEqual = false;
        }
        if (this.remotePartyId == null) {
            if (other.remotePartyId != null) {
                allFieldsEqual = false;
            }
        } else if (!this.remotePartyId.equals(other.remotePartyId)) {
            allFieldsEqual = false;
        } else {
            numberFieldsEqual = true;
        }
        if (this.remotePartyName == null) {
            if (other.remotePartyName != null) {
                allFieldsEqual = false;
            }
        } else if (!this.remotePartyName.equals(other.remotePartyName)) {
            allFieldsEqual = false;
        }
        if (this.timestamp != other.timestamp) {
            allFieldsEqual = false;
        }
        if (this.type != other.type) {
            allFieldsEqual = false;
            typeFieldsEqual = false;
        }
        return numberFieldsEqual && typeFieldsEqual && oneDialogIdIsNull || numberFieldsEqual && dialogIdFieldsEqual || allFieldsEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String timeString;
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            timeString = DATE_FORMAT.format(this.timestamp);
        }
        return "CallLog[uuid=" + this.uuid + ", timestamp=" + timeString + ", duration=" + this.duration + ", localPartyId=" + this.localPartyId + ", remotePartyId=" + this.remotePartyId + ", remotePartyAvExt=" + this.remotePartyAvExt + ", remotePartyName=" + this.remotePartyName + ", dialogId=" + this.dialogId + ", type=" + (Object)((Object)this.type) + ", bridged=" + this.bridged + ", privacy=" + this.privacy + ", isGlobalMigrated=" + this.isGlobalMigrated + "]";
    }

    public static enum CallLogType {
        unknown,
        outgoing,
        missed,
        answered,
        redirected;

    }
}

