/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.AsmLoggerUtil;
import com.avaya.asm.datamgr.objectapi.DigitMapRouterMatcher;
import com.avaya.asm.datamgr.objectapi.DigitMapRow;
import com.avaya.asm.datamgr.objectapi.DigitPattern;
import com.avaya.asm.datamgr.objectapi.DigitTree;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import org.apache.logging.log4j.Level;

public class DigitMapRouter
extends DigitTree<DigitMapRow>
implements Serializable {
    private static final Logger log = AsmLogger.getLogger(DigitMapRouter.class);
    private static final long serialVersionUID = 4172685182703741357L;

    public void insert(DigitPattern pattern, DigitMapRow row) {
        this.insert(pattern.getDigits(), pattern.getMin(), pattern.getMax(), row, new DigitMapRouterMatcher(row));
    }

    public void delete(DigitPattern pattern, DigitMapRow row) {
        this.delete(pattern.getDigits(), pattern.getMin(), pattern.getMax(), new DigitMapRouterMatcher(row));
    }

    public DigitMapRow findBestMatch(String digits) {
        return super.findBestMatch(digits, new DigitMapRouterMatcher(null));
    }

    public Long getRoute(String digits) {
        DigitMapRow row = this.findBestMatch(digits);
        if (log.isFineEnabled()) {
            log.fine((Object)("getRoute(\"" + digits + "\") found " + row));
        }
        return row == null ? null : Long.valueOf(row.getId());
    }

    public String toString() {
        return this.dumpTree();
    }

    public static void setLogLevelForJUnit() {
        AsmLoggerUtil.setLogLevel(DigitMapRouter.class, Level.INFO);
    }
}

