/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.IPAddress;
import java.text.ParseException;

public class IPv4Address
extends IPAddress {
    private static final long serialVersionUID = -7980934461694883540L;

    public IPv4Address(String string) throws ParseException {
        string = this.procZoneId(string);
        this.groups = new char[4];
        String[] octetStrings = string.split("\\.");
        if (octetStrings.length != 4) {
            throw new ParseException("Incorrect number of octets in \"" + string + "\"", 0);
        }
        for (int i = 0; i < 4; ++i) {
            int octet;
            try {
                octet = Integer.valueOf(octetStrings[i]);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid octet in \"" + string + "\"", 0);
            }
            if (octet < 0 || octet > 255) {
                throw new ParseException("Invalid octet in \"" + string + "\"", 0);
            }
            this.groups[i] = (char)octet;
        }
    }

    public IPv4Address(char[] groups) throws ParseException {
        if (groups.length != 4) {
            throw new ParseException("Invalid group length: " + groups.length, 0);
        }
        this.groups = groups;
    }

    @Override
    public IPAddress.IPAddressFamily getAddressFamily() {
        return IPAddress.IPAddressFamily.IPV4;
    }

    @Override
    public IPAddress createMask(int maskLength) throws Exception {
        if (maskLength < 0 || maskLength > 32) {
            throw new Exception("Bad maskLength");
        }
        char[] maskGroups = new char[4];
        for (int i = 0; i < maskLength; ++i) {
            int idx;
            int bit = 31 - i;
            int n = idx = 3 - bit / 8;
            maskGroups[n] = (char)(maskGroups[n] | 1 << bit % 8);
        }
        return new IPv4Address(maskGroups);
    }

    @Override
    public String toString(boolean expandedForm, boolean includeZoneId) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            builder.append(this.groups[i] & 0xFF);
            builder.append(".");
        }
        builder.append(this.groups[3] & 0xFF);
        if (includeZoneId && this.zoneId != null) {
            builder.append('%');
            builder.append(this.zoneId);
        }
        return builder.toString();
    }
}

