/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.MonitorTransition;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MonitorTransitions<E extends Enum<E>>
implements Serializable {
    private static final long serialVersionUID = -2913651788487567685L;
    private final CopyOnWriteArrayList<MonitorTransition<E>> transitions = new CopyOnWriteArrayList();
    private final int maxSize;

    public MonitorTransitions(int maxSize) {
        this.maxSize = maxSize > 0 ? maxSize : 1;
    }

    public List<MonitorTransition<E>> getTransitions() {
        return Collections.unmodifiableList(this.transitions);
    }

    protected MonitorTransition<E> getLastTransition() {
        return this.transitions.size() > 0 ? this.transitions.get(0) : null;
    }

    protected long getLastTransitionOfType(E status) {
        for (MonitorTransition<E> transition : this.transitions) {
            if (transition.getStatus() != status) continue;
            return transition.getTime();
        }
        return 0L;
    }

    public E update(E newStatus, String reason) {
        return this.update(newStatus, reason, Calendar.getInstance().getTimeInMillis());
    }

    public synchronized E update(E newStatus, String reason, long time) {
        if (this.transitions.size() == 0) {
            this.transitions.add(new MonitorTransition<E>(newStatus, time, reason));
            return null;
        }
        E oldStatus = this.transitions.get(0).getStatus();
        if (newStatus == oldStatus) {
            return oldStatus;
        }
        if (this.transitions.size() >= this.maxSize) {
            this.transitions.remove(this.maxSize - 1);
        }
        this.transitions.add(0, new MonitorTransition<E>(newStatus, time, reason));
        return oldStatus;
    }

    public String toString() {
        return this.transitions.toString();
    }
}

