/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.IPAddress;
import java.text.ParseException;

public class TransportAddress {
    protected String fqdnOrIpAddress;
    protected int port;

    public TransportAddress(String fqdnOrIpAddress, int port) {
        this.fqdnOrIpAddress = fqdnOrIpAddress;
        this.port = port;
    }

    public String getFqdnOrIpAddress() {
        return this.fqdnOrIpAddress;
    }

    public int getPort() {
        return this.port;
    }

    public static TransportAddress fromString(String string) throws ParseException {
        String fqdnOrIpAddrStr;
        int idx;
        String portStr = null;
        int len = string.length();
        if (len > 0 && string.charAt(0) == '[') {
            idx = string.indexOf(93);
            if (idx < 0) {
                throw new ParseException("no terminating ] char found in string", 0);
            }
            if (len > idx + 1 && string.charAt(idx + 1) == ':') {
                portStr = string.substring(idx + 2);
            } else if (len != idx + 1) {
                throw new ParseException("bad characters following ] char in string", 0);
            }
            fqdnOrIpAddrStr = string.substring(1, idx);
        } else {
            idx = string.indexOf(58);
            if (idx < 0) {
                fqdnOrIpAddrStr = string;
            } else {
                fqdnOrIpAddrStr = string.substring(0, idx);
                portStr = string.substring(idx + 1);
            }
        }
        int portVal = -1;
        if (portStr != null) {
            try {
                portVal = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                throw new ParseException("invalid port value in \"" + portStr + "\"", 0);
            }
        }
        return new TransportAddress(fqdnOrIpAddrStr, portVal);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fqdnOrIpAddress == null ? 0 : IPAddress.toExpandedForm(this.fqdnOrIpAddress).hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransportAddress other = (TransportAddress)obj;
        if (this.fqdnOrIpAddress == null ? other.fqdnOrIpAddress != null : !IPAddress.areEqual(this.fqdnOrIpAddress, other.fqdnOrIpAddress)) {
            return false;
        }
        return this.port == other.port;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        IPAddress ipAddress = IPAddress.fromString(this.fqdnOrIpAddress);
        if (ipAddress != null && ipAddress.getAddressFamily().equals((Object)IPAddress.IPAddressFamily.IPV6)) {
            buf.append("[");
            buf.append(ipAddress);
            buf.append("]");
        } else {
            buf.append(this.fqdnOrIpAddress);
        }
        if (this.port > 0) {
            buf.append(":");
            buf.append(this.port);
        }
        return buf.toString();
    }
}

