/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.Uptime;

public class TimeEvictionCache<T> {
    private T cachedData;
    private long evictionTimeMS;
    private Long lastUpdateTimeMS = null;

    public TimeEvictionCache(long evictionTimeMS) {
        this.evictionTimeMS = evictionTimeMS;
    }

    public synchronized boolean isStale() {
        long currentUptimeMS = Uptime.getUptimeMS();
        return this.lastUpdateTimeMS == null || this.lastUpdateTimeMS + this.evictionTimeMS < currentUptimeMS;
    }

    public void setCachedData(T cachedData) {
        this.cachedData = cachedData;
        this.lastUpdateTimeMS = Uptime.getUptimeMS();
    }

    public T getCachedData() {
        return this.cachedData;
    }
}

