/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;

public class UStoreAgentStatus {
    private static final String initCompleteFileEnvVar = "USTORE_INITCOMPLETE_FILE";
    private File initCompletionFile = null;
    private Path initCompletionPath = null;
    private Set<PosixFilePermission> initCompletionPerms;
    private final Logger log = AsmLogger.getLogger(this.getClass());

    public UStoreAgentStatus() {
        this.initCompletionFile = this.createInitCompletedFileFromEnv();
        if (this.initCompletionFile != null) {
            this.initCompletionPath = Paths.get(this.initCompletionFile.getAbsolutePath(), new String[0]);
            this.initCompletionPerms = PosixFilePermissions.fromString("rw-r--r--");
        }
    }

    public Boolean clearInitializationCompleted() {
        boolean isFinest = this.log.isFinestEnabled();
        boolean isFiner = this.log.isFinerEnabled();
        String fcn_name = "clearInitializationCompleted";
        if (isFiner) {
            this.log.finer((Object)("clearInitializationCompleted: enter, initCompletionFile=" + this.initCompletionFile));
        }
        Boolean fcnRC = null;
        try {
            fcnRC = this.initCompletionFile.delete();
            if (isFinest) {
                this.log.finest((Object)("clearInitializationCompleted: initCompletionFile.delete() returned " + fcnRC + " for file " + this.initCompletionFile));
            }
        }
        catch (SecurityException e) {
            this.log.error((Object)("clearInitializationCompleted: " + e.getClass().getSimpleName() + " thrown for " + this.initCompletionFile), (Throwable)e);
        }
        if (isFiner) {
            this.log.finer((Object)("clearInitializationCompleted: leave, returning " + fcnRC));
        }
        return fcnRC;
    }

    public Boolean setInitializationCompleted() {
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        String fcn_name = "setInitializationCompleted";
        if (isFiner) {
            this.log.finer((Object)("setInitializationCompleted: enter, initCompletionFile=" + this.initCompletionFile));
        }
        Boolean fcnRC = this.createInitializationCompletedFile();
        if (isFinest) {
            this.log.finest((Object)("setInitializationCompleted: createInitializationCompletedFile returned " + fcnRC));
        }
        if (isFiner) {
            this.log.finer((Object)("setInitializationCompleted: leave, returning " + fcnRC));
        }
        return fcnRC;
    }

    public Boolean isInitializationCompleted() {
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        String fcn_name = "isInitializationCompleted";
        if (isFiner) {
            this.log.finer((Object)("isInitializationCompleted: enter, initCompletionFile=" + this.initCompletionFile));
        }
        if (this.initCompletionFile == null) {
            this.log.info((Object)"isInitializationCompleted: initCompletionFile is null");
            if (isFiner) {
                this.log.finer((Object)"isInitializationCompleted: leave, returning null");
            }
            return null;
        }
        Boolean fcnRC = null;
        try {
            fcnRC = this.initCompletionFile.exists();
            if (isFinest) {
                this.log.finest((Object)("isInitializationCompleted: initCompletionFile.exists() returned " + fcnRC));
            }
        }
        catch (SecurityException e) {
            this.log.error((Object)("isInitializationCompleted: " + e.getClass().getSimpleName() + " thrown for " + this.initCompletionFile), (Throwable)e);
        }
        if (isFiner) {
            this.log.finer((Object)("isInitializationCompleted: leave, returning " + fcnRC));
        }
        return fcnRC;
    }

    private Boolean createInitializationCompletedFile() {
        String fcn_name = "createInitializationCompletedFile";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("createInitializationCompletedFile: enter, initCompletionFile=" + this.initCompletionFile));
        }
        if (this.initCompletionFile == null) {
            this.log.warn((Object)"createInitializationCompletedFile: initCompletionFile is null");
            return false;
        }
        Boolean fcnRC = null;
        try {
            fcnRC = this.initCompletionFile.createNewFile();
            if (isFinest) {
                this.log.finest((Object)("createInitializationCompletedFile: createNewFile returned " + fcnRC));
            }
            if (fcnRC.booleanValue()) {
                try {
                    Files.setPosixFilePermissions(this.initCompletionPath, this.initCompletionPerms);
                }
                catch (IOException | UnsupportedOperationException e) {
                    this.log.error((Object)("createInitializationCompletedFile: cannot set file permission for " + this.initCompletionPath), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            this.log.error((Object)("createInitializationCompletedFile: createNewFile() threw " + e.getClass().getSimpleName() + " for file " + this.initCompletionFile.getAbsolutePath()), (Throwable)e);
        }
        if (isFiner) {
            this.log.finer((Object)("createInitializationCompletedFile: leave, returning " + fcnRC));
        }
        return fcnRC;
    }

    private File createInitCompletedFileFromEnv() {
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        String fcn_name = "createInitCompletedFileFromEnv";
        if (isFiner) {
            this.log.finer((Object)"createInitCompletedFileFromEnv: enter");
        }
        String filePath = System.getenv(initCompleteFileEnvVar);
        if (isFinest) {
            this.log.finest((Object)("createInitCompletedFileFromEnv: env variable USTORE_INITCOMPLETE_FILE is set to " + filePath));
        }
        if (filePath == null) {
            this.log.warn((Object)"createInitCompletedFileFromEnv: USTORE_INITCOMPLETE_FILE is not defined in the environment");
            return null;
        }
        File file = new File(filePath);
        if (isFiner) {
            this.log.finer((Object)("createInitCompletedFileFromEnv: leave, returning " + file));
        }
        return file;
    }

    public static void main(String[] args) {
        Boolean rc = null;
        boolean printRC = true;
        UStoreAgentStatus usaS = null;
        if (args.length > 0) {
            switch (args[0]) {
                case "c": {
                    usaS = new UStoreAgentStatus();
                    rc = usaS.clearInitializationCompleted();
                    break;
                }
                case "e": {
                    printRC = false;
                    System.out.println(initCompleteFileEnvVar);
                    break;
                }
                case "i": {
                    usaS = new UStoreAgentStatus();
                    rc = usaS.isInitializationCompleted();
                    break;
                }
                case "s": {
                    usaS = new UStoreAgentStatus();
                    rc = usaS.setInitializationCompleted();
                    break;
                }
            }
        }
        if (printRC) {
            System.out.println("RC=" + rc);
        }
    }
}

