/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.CallableService.operations;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.call.media.MediaFactory;
import com.avaya.collaboration.call.media.MediaService;
import com.avaya.collaboration.call.media.RecordItem;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.CallableService.attributeReaders.ServiceAttributeReaderImpl;
import com.avaya.zephyr.services.sample_services.CallableService.menus.CallableServiceMainMenuMediaListener;
import com.avaya.zephyr.services.sample_services.CallableService.util.CallableServiceUtil;

public final class RecordMessageOperationImpl implements RecordMessageOperation
{
    private static final String SERVLET_PATH = "CallableServiceServlet/";
    private static final String EXTN = ".wav";
    private static final int maxRecordDuration = 300000;
    private final CallableServiceUtil callableServiceUtil;
    private final Logger logger;

    public RecordMessageOperationImpl()
    {
        this(new CallableServiceUtil(), Logger.getLogger(RecordMessageOperationImpl.class));
    }

    RecordMessageOperationImpl(final CallableServiceUtil callableServiceUtil, final Logger logger)
    {
        this.callableServiceUtil = callableServiceUtil;
        this.logger = logger;
    }

    @Override
    public void executeRecordMessageOperation(final Call call)
    {
        logger.finer("RecordMessageOperationImpl executeRecordMessageOperation ENTER ");

        try
        {
            final RecordItem recordItem = setRecordItem();
            final String fileName = (new ServiceAttributeReaderImpl()).getFileName(call.getCalledParty());
            final StringBuffer source = new StringBuffer();
            source.append(callableServiceUtil.buildUri()).append(SERVLET_PATH).append(fileName).append(EXTN);
            recordItem.setFileUri(source.toString());
            logger.finest("RecordMessageOperationImpl executeRecordMessageOperation start recording");

            callableServiceUtil.writeLog(RecordMessageOperationImpl.class, call, recordItem, logger);
            recordMessage(call, recordItem);
        }
        catch (final Exception e)
        {
            logger.error("RecordMessageOperationImpl executeRecordMessageOperation: exception=", e);
            call.drop();
        }
        logger.finer("RecordMessageOperationImpl executeRecordMessageOperation EXIT ");
    }

    private static RecordItem setRecordItem()
    {
        final RecordItem setRecordItem = MediaFactory.createRecordItem();
        setRecordItem.setTerminationKey("#");
        // Due to the Avaya Breeze NGINX has 10M size limit, so set the record file size
        // not over the limit.
        setRecordItem.setMaxDuration(maxRecordDuration);
        return setRecordItem;
    }

    private void recordMessage(final Call call, final RecordItem recordItem)
    {
        logger.finer("RecordMessageOperationImpl recordMessage ENTER");
        final MediaService mediaService = MediaFactory.createMediaService();
        final CallableServiceMainMenuMediaListener callableServiceMainMenuMediaListener =
                new CallableServiceMainMenuMediaListener(call);
        final Participant participant = call.getCallingParty();
        if (logger.isFinestEnabled())
        {
            logger.finest("RecordMessageOperationImpl recordMessage record to participant: " +
                    participant.getHandle());
        }
        mediaService.record(participant, recordItem, callableServiceMainMenuMediaListener);
        logger.finer("RecordMessageOperationImpl recordMessage EXIT");
    }
}
