/*****************************************************************************
© 2017 Avaya Inc. All rights reserved. 
****************************************************************************/

package com.avaya.zephyr.services.sample_services.OutboundHttpsSample;

import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.Mockito.when;

import javax.xml.bind.JAXBContext;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.dal.factory.CollaborationDataFactory;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.common.testutils.deencapsulation.FieldReflection;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;

@RunWith(PowerMockRunner.class)
@PrepareForTest({ServiceUtil.class, CollaborationDataFactory.class, Logger.class, JAXBContextImpl.class})
public final class AttributeReaderTest
{
    private AttributeReader attributeReader;

    private Logger loggerMock;
    
    @Mock
    private ServiceData serviceDataMock;

    @Mock
    private ServiceDescriptor serviceDescriptorMock;
    
    @Before
    public void setUp() throws Exception
    {
        loggerMock = PowerMockito.mock(Logger.class);
        PowerMockito.mockStatic(Logger.class);
        when(Logger.getLogger(ServiceUtil.class)).thenReturn(loggerMock);

        PowerMockito.mockStatic(JAXBContext.class);
        
        PowerMockito.mockStatic(ServiceUtil.class);
        when(ServiceUtil.getServiceDescriptor()).thenReturn(serviceDescriptorMock);
        
        PowerMockito.mockStatic(CollaborationDataFactory.class);
        when(CollaborationDataFactory.getServiceData(anyString(), anyString())).thenReturn(serviceDataMock);
        
        attributeReader = new AttributeReaderImpl();
        FieldReflection.setField(AttributeReaderImpl.class, attributeReader, "serviceData", serviceDataMock);
    }

    @Test
    public void getHttpMaxTotalConnections()
    {
        Assert.assertEquals(AttributeReaderImpl.DEFAULT_HTTP_MAX_TOTAL_CONNECTIONS, attributeReader.getHttpMaxTotalConnections());
    }

    @Test
    public void getHttpMaxConnectionsPerHost()
    {
        Assert.assertEquals(AttributeReaderImpl.DEFAULT_HTTP_MAX_CONNECTIONS_PER_HOST, attributeReader.getHttpMaxConnectionsPerHost());
    }

    @Test
    public void getHttpConnectionRequestTimeout()
    {
        Assert.assertEquals(AttributeReaderImpl.TIMEOUT, attributeReader.getHttpConnectionRequestTimeout());
    }

    @Test
    public void getHttpConnectTimeout()
    {
        Assert.assertEquals(AttributeReaderImpl.TIMEOUT, attributeReader.getHttpConnectTimeout());
    }

    @Test
    public void getHttpSocketTimeout()
    {
        Assert.assertEquals(AttributeReaderImpl.TIMEOUT, attributeReader.getHttpSocketTimeout());
    }
}
