/****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya Inc.
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 * Avaya Confidential & Restricted. May not be distributed further without written permission of
 * the Avaya owner.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.Authorization.http;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class HttpRequestHeaderAdder extends HttpServletRequestWrapper
{
    public HttpRequestHeaderAdder(final HttpServletRequest request)
    {
        super(request);
    }

    private final Map<String, String> headerMap = new HashMap<String, String>();

    public void addHeader(final String name, final String value)
    {
        headerMap.put(name, value);
    }

    @Override
    public String getHeader(final String name)
    {
        String headerValue = super.getHeader(name);
        if (headerMap.containsKey(name))
        {
            headerValue = headerMap.get(name);
        }
        return headerValue;
    }

    @Override
    public Enumeration<String> getHeaderNames()
    {
        final List<String> names = Collections.list(super.getHeaderNames());
        for (final String name : headerMap.keySet())
        {
            names.add(name);
        }
        return Collections.enumeration(names);
    }

    @Override
    public Enumeration<String> getHeaders(final String name)
    {
        final List<String> values = Collections.list(super.getHeaders(name));
        if (headerMap.containsKey(name))
        {
            values.add(headerMap.get(name));
        }
        return Collections.enumeration(values);
    }
}
