/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection.email;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.doThrow;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import static org.powermock.api.mockito.PowerMockito.mockStatic;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.bus.CollaborationBusException;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.email.EmailFactory;
import com.avaya.collaboration.email.EmailRequest;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.services.CallDeflection.util.ServiceAttributeReader;

@RunWith(PowerMockRunner.class)
@PrepareForTest(
{ EmailRequest.class, EmailFactory.class, CallDeflectionEmailListener.class, ServiceAttributeReader.class })
public class CallDeflectionEmailSenderTest
{
    final String emailSubject = "test subject";
    final String emailBody = "test body";
    final String emailFrom = "from@domain.com";
    final String emailReplyTo = "replyTo@domain.com";

    private CallDeflectionEmailSender callDeflectionEmailSenderTest;
    @Mock
    private Logger mockLogger;
    @Mock
    private EmailRequest mockEmailRequest;
    @Mock
    private CallDeflectionEmailListener mockCallDeflectionEmailListener;
    @Mock
    private CollaborationBusException exception;

    @Mock
    private ServiceAttributeReader mockServiceAttributeReader;

    @Before
    public void setup() throws Exception
    {
        callDeflectionEmailSenderTest = new CallDeflectionEmailSender(mockServiceAttributeReader, mockLogger);
    }

    @Test
    public void testSendEmail() throws Exception
    {
        when(mockServiceAttributeReader.getEmailTo()).thenReturn("emailTo");
        when(mockServiceAttributeReader.getEmailFrom()).thenReturn(emailFrom);
        mockStatic(EmailFactory.class);
        when(EmailFactory.createEmailRequest()).thenReturn(mockEmailRequest);
        assertTrue(callDeflectionEmailSenderTest.sendEmail());
    }

    @Test
    public void testSendEmailToBlank() throws Exception
    {
        when(mockServiceAttributeReader.getEmailTo()).thenReturn("");
        assertFalse(callDeflectionEmailSenderTest.sendEmail());
        verify(mockLogger).info("Info: Email will not be sent.");
    }

    @Test
    public void testSendEmailFromBlank() throws Exception
    {
        when(mockServiceAttributeReader.getEmailTo()).thenReturn("emailTo");
        mockStatic(EmailFactory.class);
        when(EmailFactory.createEmailRequest()).thenReturn(mockEmailRequest);
        assertTrue(callDeflectionEmailSenderTest.sendEmail());
        verify(mockLogger).info("Will attempt to use the email connector's 'default sender' attribute for the 'from' address.");
    }

    @Test
    public void testSendEmailReplyToException() throws NoAttributeFoundException, ServiceNotFoundException, CollaborationBusException
    {
        when(mockServiceAttributeReader.getEmailTo()).thenReturn("emailTo");
        when(mockServiceAttributeReader.getEmailFrom()).thenReturn(emailFrom);
        mockStatic(EmailFactory.class);
        when(EmailFactory.createEmailRequest()).thenReturn(mockEmailRequest);
        doThrow(exception).when(mockEmailRequest).send();
        callDeflectionEmailSenderTest.sendEmail();
        verify(mockLogger).error("Error: Error occured sending email.", exception);
    }
}
