/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.CallableService.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.util.logger.Logger;

public final class CallableServiceHttpUtil
{
    private static final String SERVLET_PATH = "CallableServiceServlet/";
    private static final String HTTP_DELETE = "DELETE";
    private static final String HTTP_PUT = "PUT";
    private static final String AUDIO_FILE_DOES_NOT_EXIST = "DOES NOT EXIST";
    private final Logger logger;

    public CallableServiceHttpUtil()
    {
        this(Logger.getLogger(CallableServiceHttpUtil.class));
    }

    CallableServiceHttpUtil(final Logger logger)
    {
        this.logger = logger;
    }

    public HttpURLConnection setUpHttpURLConnection(final String servletFileName, final String httpMethod)
            throws IOException, NoAttributeFoundException
    {
        final CallableServiceUtil callableServiceUtil = new CallableServiceUtil();

        final StringBuffer httpPath = new StringBuffer();
        httpPath.append(callableServiceUtil.buildUri()).append(SERVLET_PATH).append(servletFileName);

        final URL website = new URL(httpPath.toString());

        final HttpURLConnection servletConnection = (HttpURLConnection) website.openConnection();
        servletConnection.setRequestMethod(httpMethod);
        servletConnection.connect();
        // servletConnection.disconnect();

        return servletConnection;
    }

    public int requestDelete(final String deleteFile)
    {
        logger.finer("CallableServiceHttpUtil requestDelete ENTER");
        try
        {
            final int response = (setUpHttpURLConnection(deleteFile, HTTP_DELETE)).getResponseCode();
            if (logger.isFinerEnabled())
            {
                logger.finer("CallableServiceHttpUtil requestDelete delPrevRecorded: doDelete called with response: " +
                        response);
            }
            logger.finer("CallableServiceHttpUtil requestDelete EXIT");
            return response;
        }
        catch (final Exception e)
        {
            logger.error("CallableServiceHttpUtil: Http connection failure: exception=", e);
            logger.finer("CallableServiceHttpUtil requestDelete EXIT");
            return -1;
        }
    }

    public String requestPut(final String fileName)
    {
        logger.finer("CallableServiceHttpUtil requestPut ENTER");
        try
        {
            HttpURLConnection httpURLConnection = setUpHttpURLConnection(fileName, HTTP_PUT);
            final InputStream readResponse = httpURLConnection.getInputStream();
            final BufferedReader connectionStream = new BufferedReader(new InputStreamReader(readResponse));
            String responseWithFileStatus = connectionStream.readLine();
            if (responseWithFileStatus == null)
            {
                // This means the file does not exist
                logger.finest("CallableServiceHttpUtil requestPut could not find the file");
                responseWithFileStatus = AUDIO_FILE_DOES_NOT_EXIST;
            }
            connectionStream.close();
            httpURLConnection.disconnect();
            logger.finer("CallableServiceHttpUtil requestPut EXIT");
            return responseWithFileStatus;
        }
        catch (final Exception e)
        {
            logger.error("CallableServiceHttpUtil requestPut  Http connection failure: exception=", e);
            logger.finer("CallableServiceHttpUtil requestPut EXIT");
            return AUDIO_FILE_DOES_NOT_EXIST;
        }

    }
}
