/*****************************************************************************
 * © 2014 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.Callingpolicies;

import java.util.ArrayList;
import java.util.List;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.NoServiceProfileFoundException;
import com.avaya.collaboration.businessdata.api.NoUserFoundException;
import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.dal.factory.CollaborationDataFactory;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;

/**
 * This retrieves the attributes associated with the service.
 * 
 * @see <code>properties.xml</code>
 */
public final class ServiceAttributeReaderImpl implements ServiceAttributeReader
{
    private final ServiceData serviceData;

    private final Logger logger;

    public ServiceAttributeReaderImpl()
    {
        this(ServiceUtil.getServiceDescriptor());
    }

    ServiceAttributeReaderImpl(final ServiceDescriptor serviceDescriptor)
    {
        this.serviceData = CollaborationDataFactory.getServiceData(serviceDescriptor.getName(),
                serviceDescriptor.getVersion());

        this.logger = Logger.getLogger(CallingPoliciesCallListener.class);
    }

    @Override
    public List<String> getForkedDestinations(final Participant participant) throws NoUserFoundException,
            NoAttributeFoundException, ServiceNotFoundException, NoServiceProfileFoundException
    {
        final List<String> forkedDestinations = new ArrayList<String>();

        forkedDestinations.add(retrieveForkedDestination(participant, "forkDestination1Attribute"));
        forkedDestinations.add(retrieveForkedDestination(participant, "forkDestination2Attribute"));

        return forkedDestinations;
    }

    private String retrieveForkedDestination(final Participant participantUserAddress,
            final String forkAttribute)
    {
        try
        {
            final String participantAddress = participantUserAddress.getAddress();
            return serviceData.getServiceAttribute(participantAddress, forkAttribute);
        }
        catch (final Exception e)
        {
            logger.error("retrieveForkedDestination: exception=", e);
            return null;
        }
    }

    @Override
    public String getRedirectNumber(final Participant participantUserAddress) throws NoUserFoundException,
            NoAttributeFoundException, ServiceNotFoundException, NoServiceProfileFoundException
    {
        final String participantAddress = participantUserAddress.getAddress();
        final String redirectNumber =
                serviceData.getServiceAttribute(participantAddress, "redirectDestinationAttribute");

        return redirectNumber;
    }
}
