package com.avaya.zephyr.services.dynamicteamformation.sms;

import static org.easymock.EasyMock.anyObject;
import static org.easymock.EasyMock.expect;
import static org.powermock.api.easymock.PowerMock.createMock;
import static org.powermock.api.easymock.PowerMock.replayAll;
import static org.powermock.api.easymock.PowerMock.verifyAll;

import java.util.ArrayList;
import java.util.Arrays;

import org.junit.Before;
import org.junit.Test;

import com.avaya.collaboration.sms.SmsRequest;
import com.avaya.collaboration.sms.SmsResponse;
import com.avaya.collaboration.util.logger.Logger;

public class DynamicTeamFormationSmsListenerTest
{
    private DynamicTeamFormationSmsListener dynamicTeamFormationSmsListenerTest;
    private SmsRequest mockSmsRequest;
    private SmsResponse mockSmsResponse;
    private Logger mockLogger;

    @Before
    public void setUpMockCommon() throws Exception
    {
        mockSmsRequest = createMock(SmsRequest.class);
        mockSmsResponse = createMock(SmsResponse.class);
        mockLogger = createMock(Logger.class);
        dynamicTeamFormationSmsListenerTest = new DynamicTeamFormationSmsListener(mockSmsRequest, mockLogger);
    }

    private void setupMockSmsRequest()
    {
        expect(mockSmsRequest.getRecipients()).andReturn(new ArrayList<String>(
                Arrays.asList("to@domain.com")));
        expect(mockSmsRequest.getText()).andReturn("body");
    }

    private void setupMockSmsResponse()
    {
        expect(mockSmsResponse.getFailedRecipients()).andReturn(new ArrayList<String>(
                Arrays.asList("failed@domain.com")));
        expect(mockSmsResponse.getPendingRecipients()).andReturn(new ArrayList<String>(
                Arrays.asList("pending@domain.com")));
        expect(mockSmsResponse.getDeliveredRecipients()).andReturn(new ArrayList<String>(
                Arrays.asList("delivered@domain.com")));
        expect(mockSmsResponse.getStatus()).andReturn(5);
        expect(mockSmsResponse.getDetail()).andReturn("detail");
    }

    @Test
    public void testResponseReceived() throws Exception
    {
        // Test Info

        // Test Data

        // Setup mocks
        setupMockSmsRequest();
        setupMockSmsResponse();
        mockLogger.info((String) anyObject());

        // Replay, Execute, and Verify
        replayAll();
        dynamicTeamFormationSmsListenerTest.responseReceived(mockSmsResponse);
        verifyAll();
    }

}
