/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection.sms;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import java.util.ArrayList;
import java.util.Arrays;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.sms.SmsRequest;
import com.avaya.collaboration.sms.SmsResponse;
import com.avaya.collaboration.util.logger.Logger;

@RunWith(PowerMockRunner.class)
public class CallDeflectionSmsListenerTest
{
    private CallDeflectionSmsListener CallDeflectionSmsListenerTest;
    @Mock
    private SmsRequest mockSmsRequest;
    @Mock
    private SmsResponse mockSmsResponse;
    @Mock
    private Logger mockLogger;

    @Before
    public void setupn() throws Exception
    {
        CallDeflectionSmsListenerTest = new CallDeflectionSmsListener(mockSmsRequest, mockLogger);
    }

    @Test
    public void testResponseReceived() throws Exception
    {
        when(mockSmsRequest.getRecipients()).thenReturn(new ArrayList<String>(
                Arrays.asList("to@domain.com")));
        when(mockSmsRequest.getText()).thenReturn("body");

        when(mockSmsResponse.getFailedRecipients()).thenReturn(new ArrayList<String>(
                Arrays.asList("failed@domain.com")));
        when(mockSmsResponse.getPendingRecipients()).thenReturn(new ArrayList<String>(
                Arrays.asList("pending@domain.com")));
        when(mockSmsResponse.getDeliveredRecipients()).thenReturn(new ArrayList<String>(
                Arrays.asList("delivered@domain.com")));
        when(mockSmsResponse.getStatus()).thenReturn(5);
        when(mockSmsResponse.getDetail()).thenReturn("detail");

        CallDeflectionSmsListenerTest.responseReceived(mockSmsResponse);
        verify(mockLogger).info(Matchers.any(String.class));
    }
}
