/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection.util;

import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;
import static org.powermock.api.mockito.PowerMockito.mockStatic;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.NoServiceProfileFoundException;
import com.avaya.collaboration.businessdata.api.NoUserFoundException;
import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.call.ParticipantFactory;
import com.avaya.collaboration.dal.factory.CollaborationDataFactory;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;

@RunWith(PowerMockRunner.class)
@PrepareForTest(
{ CollaborationDataFactory.class, ServiceUtil.class, ParticipantFactory.class })
public class ServiceAttributeReaderImplTest
{
    @Mock
    private ServiceDescriptor serviceDescriptor;
    @Mock
    private ServiceData serviceData;
    @Mock
    private Logger logger;
    private ServiceAttributeReader serviceAttributeReader;

    @Before
    public void setUp() throws Exception
    {
        when(logger.isFinestEnabled()).thenReturn(true);
        mockStatic(ServiceUtil.class);
        mockStatic(CollaborationDataFactory.class);
        when(ServiceUtil.getServiceDescriptor()).thenReturn(serviceDescriptor);
        final String serviceDescriptorName = serviceDescriptor.getName();
        final String serviceDescriptorVersion = serviceDescriptor.getVersion();
        when(CollaborationDataFactory.getServiceData(serviceDescriptorName, serviceDescriptorVersion)).thenReturn(serviceData);
        serviceAttributeReader = new ServiceAttributeReaderImpl(serviceDescriptor, logger);
    }

    @Test
    public void getAgentNumber()
            throws NoAttributeFoundException, ServiceNotFoundException, NoUserFoundException, NoServiceProfileFoundException
    {
        when(serviceData.getServiceAttribute("com.avaya.example.agentNumber")).thenReturn("111");
        assertTrue(serviceAttributeReader.getAgentNumber().equals("111"));
    }

    @Test
    public void getAgentDomain()
            throws NoAttributeFoundException, ServiceNotFoundException, NoUserFoundException, NoServiceProfileFoundException
    {
        when(serviceData.getServiceAttribute("com.avaya.example.agentDomian")).thenReturn("domain");
        assertTrue(serviceAttributeReader.getAgentDomain().equals("domain"));
    }

    @Test
    public void getAnnouncementSource()
            throws NoAttributeFoundException, ServiceNotFoundException, NoUserFoundException, NoServiceProfileFoundException
    {
        when(serviceData.getServiceAttribute("com.avaya.example.sourcePath")).thenReturn("source");
        assertTrue(serviceAttributeReader.getAnnouncementSourcePath().equals("source"));
    }

    @Test
    public void getEmailTos()
            throws NoAttributeFoundException, ServiceNotFoundException, NoUserFoundException, NoServiceProfileFoundException
    {
        when(serviceData.getServiceAttribute("com.avaya.example.emailTo")).thenReturn("emailTo");
        assertTrue(serviceAttributeReader.getEmailTo().equals("emailTo"));
    }

    @Test
    public void getEmailFrom()
            throws NoAttributeFoundException, ServiceNotFoundException, NoUserFoundException, NoServiceProfileFoundException
    {
        when(serviceData.getServiceAttribute("com.avaya.example.emailFrom")).thenReturn("emailFrom");
        assertTrue(serviceAttributeReader.getEmailFrom().equals("emailFrom"));
    }

    @Test
    public void getSmsFrom()
            throws NoAttributeFoundException, ServiceNotFoundException, NoUserFoundException, NoServiceProfileFoundException
    {
        when(serviceData.getServiceAttribute("com.avaya.example.smsFrom")).thenReturn("smsFrom");
        assertTrue(serviceAttributeReader.getSmsFrom().equals("smsFrom"));
    }

    @Test
    public void getSmsTo()
            throws NoAttributeFoundException, ServiceNotFoundException, NoUserFoundException, NoServiceProfileFoundException
    {
        when(serviceData.getServiceAttribute("com.avaya.example.smsTo")).thenReturn("smsTo");
        assertTrue(serviceAttributeReader.getSmsTo().equals("smsTo"));
    }
}
