package com.avaya.zephyr.services.sample_services.CallableService.operations;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.call.media.DigitOptions;
import com.avaya.collaboration.call.media.MediaFactory;
import com.avaya.collaboration.call.media.MediaService;
import com.avaya.collaboration.call.media.PlayItem;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.CallableService.PromptsToPlay;
import com.avaya.zephyr.services.sample_services.CallableService.util.CallableServiceUtil;

@RunWith(PowerMockRunner.class)
@PrepareForTest(
{ CallableServiceUtil.class, MediaFactory.class })
public class PromptAndCollectOperationImplTest
{

    private PromptAndCollectOperationImpl promptAndCollectOperationImpl;

    @Mock
    private CallableServiceUtil callableServiceUtil;
    @Mock
    private DigitOptions digitOptions;
    @Mock
    private PlayItem playItem;
    @Mock
    private MediaService mediaService;
    @Mock
    private Call call;
    @Mock
    private Participant participant;
    @Mock
    private Logger logger;

    @Before
    public void setUp()
    {
        promptAndCollectOperationImpl = new PromptAndCollectOperationImpl(callableServiceUtil, logger);
        when(logger.isFinerEnabled()).thenReturn(true);
        PowerMockito.mockStatic(MediaFactory.class);
        BDDMockito.given(MediaFactory.createPlayItem()).willReturn(playItem);
        BDDMockito.given(MediaFactory.createMediaService()).willReturn(mediaService);
        BDDMockito.given(MediaFactory.createDigitOptions()).willReturn(digitOptions);
        when(call.getCallingParty()).thenReturn(participant);
        when(participant.getHandle()).thenReturn("1234");
    }

    @Test
    public void executePromptAndCollectOperation_approve_or_discard()
    {
        promptAndCollectOperationImpl
                .executePromptAndCollectOperation(call, PromptsToPlay.APPROVE_OR_DISCARD);
        verify(callableServiceUtil).writeLog(PromptAndCollectOperationImpl.class, call, digitOptions,
                playItem, logger);
    }

    @Test
    public void executePromptAndCollectOperation_main_menu()
    {
        promptAndCollectOperationImpl.executePromptAndCollectOperation(call, PromptsToPlay.MAINMENU);
        verify(callableServiceUtil).writeLog(PromptAndCollectOperationImpl.class, call, digitOptions,
                playItem, logger);
    }

}
