/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.Callingpolicies;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import com.avaya.asm.datamgr.AssetDM;
import com.avaya.collaboration.util.logger.Logger;

@RunWith(MockitoJUnitRunner.class)
public class TrafficInterfaceAddressRetrieverImplTest
{
    private static final String LOG_BGN = "getTrafficInterfaceAddress: entity ip addr=";
    @Mock
    private AssetDM mAstDM;
    @Mock
    private Logger logger;
    private TrafficInterfaceAddressRetriever trafficIntfceAddrRtrvr;

    @Before
    public void setUp() throws Exception
    {
        trafficIntfceAddrRtrvr = new TrafficInterfaceAddressRetrieverImpl(mAstDM, logger);
        when(logger.isFinestEnabled()).thenReturn(true);
    }

    @Test
    public void getTrafficInterfaceAddress_Success()
    {
        when(mAstDM.getMyAssetIp()).thenReturn("10.129.179.214");
        final String localAsset = mAstDM.getMyAssetIp();
        trafficIntfceAddrRtrvr.getTrafficInterfaceAddress();

        verify(logger).isFinestEnabled();
        verify(logger).finest(LOG_BGN + localAsset);
    }

    @Test
    public void getTrafficInterfaceAddress_Null()
    {
        when(mAstDM.getMyAssetIp()).thenReturn(" ");
        final String localAsset = mAstDM.getMyAssetIp();
        trafficIntfceAddrRtrvr.getTrafficInterfaceAddress();

        verify(logger).isFinestEnabled();
        verify(logger).finest(LOG_BGN + localAsset);
    }
}
