/****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya Inc.
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 * Avaya Confidential & Restricted. May not be distributed further without written permission of
 * the Avaya owner.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.Authorization.TaskDashboard.listener;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import javax.servlet.ServletContextEvent;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.collaboration.authorization.client.AuthorizationClientHelper;
import com.avaya.collaboration.authorization.spi.AccessTokenProvider;
import com.avaya.collaboration.ssl.util.SSLUtilityException;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.common.testutils.deencapsulation.Deencapsulation;
import com.avaya.zephyr.platform.dao.AusServiceDAO;
import com.avaya.zephyr.services.sample_services.Authorization.TaskDashboard.provider.EndpointProvider;
import com.avaya.zephyr.services.sample_services.Authorization.TaskDashboard.provider.HttpUtilProvider;

@RunWith(MockitoJUnitRunner.class)
public class ApplicationLifecycleListenerTest
{
    ApplicationLifecycleListener applicationLifecycleListener;
    @Mock
    HttpUtilProvider httpUtilProviderMock;
    @Mock
    EndpointProvider endPointProviderMock;
    @Mock
    ServletContextEvent servletContextEventMock;
    @Mock
    AusServiceDAO ausServiceDaoMock;
    @Mock
    AccessTokenProvider accessTokenProviderMock;
    @Mock
    Logger loggerMock;

    @Before
    public void before()
    {
        applicationLifecycleListener = new ApplicationLifecycleListener(httpUtilProviderMock,
                endPointProviderMock, loggerMock);
        Deencapsulation.setField(AuthorizationClientHelper.class,
                "tokenProvider", accessTokenProviderMock);
    }

    @Test
    public void contextInitialized_resourceSetup()
    {
        applicationLifecycleListener.contextInitialized(servletContextEventMock);
        
        verify(endPointProviderMock).buildResourceEndpoint();
        try
        {
            verify(httpUtilProviderMock).buildHttpClient();
        }
        catch (SSLUtilityException e)
        {
            e.printStackTrace();
        }
    }

    @Test
    public void contextDestroyed_resourceRelease()
    {
        applicationLifecycleListener.contextDestroyed(servletContextEventMock);
        
        verify(httpUtilProviderMock).closeHttpClient();
        verify(accessTokenProviderMock).shutDown();
    }
}
