/****************************************************************************
* Copyright Avaya Inc., All Rights Reserved.
* THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
* The copyright notice above does not evidence any actual or intended publication of such source code.
* Some third-party source code components may have been modified from their original versions by Avaya Inc.
* The modifications are Copyright Avaya Inc., All Rights Reserved.
* Avaya Confidential & Restricted. May not be distributed further without written permission of
* the Avaya owner.
****************************************************************************/
package com.avaya.zephyr.services.sample_services.Authorization.TaskRepository.json;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import com.google.gson.annotations.SerializedName;

@XmlRootElement
public final class Task
{
    @SerializedName("id")
    @XmlElement(name = "id")
    private String taskId;
    @SerializedName("userId")
    @XmlElement(name = "userId")
    private String userId;
    @SerializedName("title")
    @XmlElement(name = "title")
    private String title;
    @SerializedName("description")
    @XmlElement(name = "description")
    private String description;
    @SerializedName("closed")
    @XmlElement(name = "closed")
    private boolean closed;
    @SerializedName("createdAt")
    @XmlElement(name = "createdAt")
    private String createdAtString;

    public Task()
    {
    }

    public Task(final String taskId, final String userId, final String title, final String description,
            final boolean closed, final String createdAtString)
    {
        this.taskId = taskId;
        this.userId = userId;
        this.title = title;
        this.description = description;
        this.closed = closed;
        this.createdAtString = createdAtString;
    }

    public String getTaskId()
    {
        return taskId;
    }

    public void setTaskId(final String taskId)
    {
        this.taskId = taskId;
    }

    public String getUserId()
    {
        return userId;
    }

    public void setUserId(final String userId)
    {
        this.userId = userId;
    }

    public String getTitle()
    {
        return title;
    }

    public void setTitle(final String title)
    {
        this.title = title;
    }

    public String getDescription()
    {
        return description;
    }

    public void setDescription(final String description)
    {
        this.description = description;
    }

    public boolean isClosed()
    {
        return closed;
    }

    public void setClosed(final boolean closed)
    {
        this.closed = closed;
    }

    public String getCreatedAtString()
    {
        return createdAtString;
    }

    public void setCreatedAtString(final String createdAtString)
    {
        this.createdAtString = createdAtString;
    }

    @Override
    public int hashCode()
    {
        return new HashCodeBuilder()
                .append(taskId)
                .append(userId)
                .append(title)
                .append(description)
                .append(closed)
                .append(createdAtString)
                .toHashCode();
    }

    @Override
    public boolean equals(final Object other)
    {
        return EqualsBuilder.reflectionEquals(this, other);
    }
}
