/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.util.logger.Logger;

@RunWith(PowerMockRunner.class)
public final class CallDeflectionCallListenerTest
{
    @Mock
    private CallDeflectionMediaOperations callDeflectionOperation;
    @Mock
    private Call call;
    @Mock
    Participant participant;

    @Mock
    private Logger logger;
    CallDeflectionCallListener callDeflectionCallListener;

    @Before
    public void setupn()
    {
        when(logger.isFinerEnabled()).thenReturn(true);
        when(logger.isFinestEnabled()).thenReturn(true);
        callDeflectionCallListener = new CallDeflectionCallListener(callDeflectionOperation, logger);
    }

    @Test
    public void callIntercepted()
    {
        callDeflectionCallListener.callIntercepted(call);
        verify(callDeflectionOperation).executePromptAndCollectOperation(call, 1);
    }

    @Test
    public void callAnswered()
    {
        when(call.getAnsweringParty()).thenReturn(participant);
        callDeflectionCallListener.callAnswered(call);
        verify(logger).finest("callAnswered answeringParty = null");
    }

    @Test
    public void callAlerting()
    {
        callDeflectionCallListener.callAlerting(participant);
        verify(logger).finest("callAlerting ENTER/EXIT " + participant);
    }

    @Test
    public void participantDropped()
    {
        callDeflectionCallListener.participantDropped(call, participant, null);
        verify(logger).finest("participantDropped EXIT - Last participant dropped.");
    }

    @Test
    public void callTerminated()
    {
        callDeflectionCallListener.callTerminated(call, null);
        verify(logger).finer("callTerminated EXIT");
    }

    @Test
    public void addParticipantFailed()
    {
        when(call.getAnsweringParty()).thenReturn(participant);
        List<Participant> list = new ArrayList<Participant>();
        list.add(participant);
        when(call.getActiveParties()).thenReturn(list);
        when(call.getAlertingParties()).thenReturn(list);
        callDeflectionCallListener.addParticipantFailed(call, participant, null);
        verify(logger).finest("addParticipantFailed answeringParty = null");
    }
}
