/****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya Inc.
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 * Avaya Confidential & Restricted. May not be distributed further without written permission of
 * the Avaya owner.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.CallableService;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

import com.avaya.collaboration.util.logger.Logger;

public final class CacheWebFilter implements Filter
{
    public static Logger logger = Logger.getLogger(CacheWebFilter.class.getName()); // NOSONAR not a final so it can be mocked in junits

    @Override
    public void init(final FilterConfig filterConfig) throws ServletException
    {
        logger.finer("doInit ENTER");
    }

    @Override
    public void doFilter(final ServletRequest servletRequest, final ServletResponse servletResponse, final FilterChain filterChain)
            throws IOException, ServletException
    {
        logger.finer("doFilter ENTER");
        HttpServletResponse httpServletResponse = (HttpServletResponse) servletResponse;
        // set cache directives
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        httpServletResponse.setDateHeader("Expires", 0L);
        filterChain.doFilter(servletRequest, servletResponse);
        logger.finer("doFilter EXIT");
    }

    @Override
    public void destroy()
    {
        logger.finer("destroy ENTER/EXIT");
    }
}

