/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.CallableService;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.CallListenerAbstract;
import com.avaya.collaboration.call.TheCallListener;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.CallableService.operations.PlayAnnouncementOperation;
import com.avaya.zephyr.services.sample_services.CallableService.operations.PlayAnnouncementOperationImpl;

@TheCallListener
public final class CallableServiceCallListener extends CallListenerAbstract
{
    private final PlayAnnouncementOperation playAnnouncementOperation;
    private final Logger logger;

    public CallableServiceCallListener()
    {
        this(new PlayAnnouncementOperationImpl(), Logger.getLogger(CallableServiceCallListener.class));
    }

    CallableServiceCallListener(final PlayAnnouncementOperation playAnnouncementOperation, final Logger logger)
    {
        this.playAnnouncementOperation = playAnnouncementOperation;
        this.logger = logger;
    }

    @Override
    public void callIntercepted(final Call call)
    {
        logger.finer("callIntercepted ENTER ");

        if (call.wasServiceCalled())
        {
            call.setAttribute("nextPrompt", PromptsToPlay.MAINMENU);
            playAnnouncementOperation.executePlayAnnouncementOperation(call, PromptsToPlay.GREETING);
        }
        else
        {
            logger.error("The CallableService sample snap-in can only be invoked as a CallableService, not a sequenced service");
        }

        logger.finer("callIntercepted EXIT ");
    }
}