package com.avaya.zephyr.services.sample_services.CallableService.attributeReaders;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.businessdata.api.ServiceData;
//import static org.mockito.Mockito.verify;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.dal.factory.CollaborationDataFactory;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;

@RunWith(PowerMockRunner.class)
@PrepareForTest({CollaborationDataFactory.class})
public class ServiceAttributeReaderImplTest {
	
	ServiceAttributeReaderImpl serviceAttributeReaderImpl;
	
	@Mock
	ServiceDescriptor serviceDescriptor;
	
	@Mock
	Participant participantUserAddress;
	
	@Mock
	ServiceData serviceData;
	
	@Before
	public void setUp()
	{
		PowerMockito.mockStatic(CollaborationDataFactory.class);
		when(CollaborationDataFactory.getServiceData(Mockito.anyString(), Mockito.anyString())).thenReturn(serviceData);
		serviceAttributeReaderImpl = new ServiceAttributeReaderImpl(serviceDescriptor);
	}
	
	@Test
	public void getFileName() throws Exception
	{
		when(serviceData.getServiceAttribute(Mockito.anyString(), Mockito.anyString())).thenReturn("testfile.wav");
	    assertEquals("testfile.wav", serviceAttributeReaderImpl.getFileName(participantUserAddress));
	}

}
