package com.avaya.zephyr.services.sample_services.CallableService.operations;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.api.mockito.PowerMockito;
//import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;


import com.avaya.asm.datamgr.DMFactory;
import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.call.media.MediaFactory;
import com.avaya.collaboration.call.media.MediaService;
import com.avaya.collaboration.call.media.PlayItem;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.CallableService.PromptsToPlay;
import com.avaya.zephyr.services.sample_services.CallableService.util.CallableServiceUtil;

@RunWith(PowerMockRunner.class)
@PrepareForTest(
{ CallableServiceUtil.class, MediaFactory.class, DMFactory.class })
//@PowerMockIgnore("javax.net.ssl.*")
public class PlayAnnouncementOperationImplTest
{

    PlayAnnouncementOperationImpl playAnnouncementOperationImpl;

    @Mock
    CallableServiceUtil callableServiceUtil;

    @Mock
    PlayItem playItem;

    @Mock
    MediaService mediaService;

    @Mock
    Call call;

    @Mock
    Participant participant;

    @Mock
    Logger logger;
    
    @Before
    public void setUp()
    {
        playAnnouncementOperationImpl = new PlayAnnouncementOperationImpl(callableServiceUtil, logger);
        PowerMockito.mockStatic(MediaFactory.class);
        when(MediaFactory.createPlayItem()).thenReturn(playItem);
        when(MediaFactory.createMediaService()).thenReturn(mediaService);
        when(call.getCallingParty()).thenReturn(participant);
        when(participant.getHandle()).thenReturn("1234");
    }

    @Test
    public void playRecordAnnouncement() throws Exception
    {
        when(logger.isFinestEnabled()).thenReturn(true);
        playAnnouncementOperationImpl.executePlayAnnouncementOperation(call, PromptsToPlay.RECORD);
        verify(callableServiceUtil).writeLog(PlayAnnouncementOperationImpl.class, call, playItem, logger);
    }

    @Test
    public void playBeepAnnouncement() throws Exception
    {
        playAnnouncementOperationImpl.executePlayAnnouncementOperation(call, PromptsToPlay.BEEP);
        verify(callableServiceUtil).writeLog(PlayAnnouncementOperationImpl.class, call, playItem, logger);
    }
    
    @Test
    public void playStringAnnouncement()
    {
         when(logger.isFinestEnabled()).thenReturn(true);
    	 playAnnouncementOperationImpl.executePlayAnnouncementOperation(call, "BEEP");
    	 verify(callableServiceUtil).writeLog(PlayAnnouncementOperationImpl.class, call, playItem, logger);
    }
}
