/////////////////////////////////////////////////////////////////////////////
//Copyright Avaya Inc., All Rights Reserved
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AVAYA INC
// The copyright notice above does not evidence any
// actual or intended publication of such source code.
// Some third-party source code components may have been modified from
// their original versions by Avaya Inc.
// The modifications are Copyright Avaya Inc., All Rights Reserved.
//
//////////////////////////////////////////////////////////////////////////////
package com.avaya.services.whitelist.rest;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import com.avaya.collaboration.util.logger.Logger;
import com.avaya.services.whitelist.db.WhiteListDao;
import com.avaya.services.whitelist.db.WhiteListEntry;

@Path("/entries")
@Stateless
public class WhitelistsResource
{
    private Logger logger = Logger.getLogger(WhitelistsResource.class);

    @EJB
    private WhiteListDao whiteListDao;
    private List<WhiteListEntry> whiteListEntryList = null;

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public List<WhiteListEntry> getWhiteListEntries()
    {
        logger.info("Inside REST : WhitelistsResource :: getWhiteListEntries ");
        whiteListEntryList = whiteListDao.queryWhiteListEntries();
        return whiteListEntryList;

    }
}
