///////////////////////////////////////////////////////////////////////////////
//// MultiChanBroadcastServlet.java
////Description:: This class is the MCB servlet, starting point of MCB request, which initiate Email,SMS and Announcement.
//// Copyright 2013 Avaya Inc. All rights reserved.
//// Usage of this source is bound to the terms described
//// in http://www.avaya.com/devconnect
//// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
/////////////////////////////////////////////////////////////////////////////////

package com.avaya.zephyr.services.multichanbroadcast;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.dal.factory.CollaborationDataFactory;
import com.avaya.collaboration.service.activity.ServiceActivityData;
import com.avaya.collaboration.service.activity.ServiceActivityDataFactory;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;
import com.avaya.zephyr.services.multichanbroadcast.announcementcall.MultiChanBroadcastAnnouncementSender;
import com.avaya.zephyr.services.multichanbroadcast.email.MultiChanBroadcastEmailSender;
import com.avaya.zephyr.services.multichanbroadcast.sms.MultiChanBroadcastSmsSender;

/**
 * Servlet implementation class MultiChanBroadcastServlet
 */
@WebServlet("/MultiChanBroadcastServlet")
public class MultiChanBroadcastServlet extends HttpServlet
{
    private static final long serialVersionUID = 7279537315432264855L;
    private final transient Logger logger;

    /**
     * @see HttpServlet#HttpServlet()
     */
    public MultiChanBroadcastServlet()
    {
        super();
        this.logger = Logger.getLogger(MultiChanBroadcastServlet.class);
    }

    // JUnit constructor
    protected MultiChanBroadcastServlet(final Logger logger)
    {
        super();
        this.logger = logger;
    }

    /**
     * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse
     *      response)
     */
    @Override
    protected void doPost(final HttpServletRequest httpServletRequest,
            final HttpServletResponse httpServletResponse) throws ServletException, IOException
    {
        logger.info("doPost");

        final ServiceActivityData serviceActivityData = ServiceActivityDataFactory.createServicActivityData();

        serviceActivityData.increment();
        logger.info("MCB : Activity Increment : " + serviceActivityData.get());

        final PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType("text/plain");

        // Get service descriptor to allow getting of service attributes from
        // SMGR GUI
        final ServiceDescriptor serviceDescriptor = ServiceUtil.getServiceDescriptor();
        ServiceData serviceData = null;
        if (serviceDescriptor != null)
        {
            serviceData = CollaborationDataFactory.getServiceData(serviceDescriptor.getName(),
                    serviceDescriptor.getVersion());
        }
        else
        {
            serviceActivityData.decrement();
            logger.info("MCB : Activity Decrement : " + serviceActivityData.get());
            logger.error("Cant get service descriptor");
            printWriter.println("Error occured getting the service descriptor");
            httpServletResponse.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
            return;
        }

        // BROADCAST EMAIL
        final MultiChanBroadcastEmailSender emailSender =
                new MultiChanBroadcastEmailSender(serviceData, httpServletRequest, printWriter);
        final boolean sentEmail = emailSender.sendEmail();

        // BROADCAST ANNOUNCEMENT
        final MultiChanBroadcastAnnouncementSender announcementSender =
                new MultiChanBroadcastAnnouncementSender(serviceData, httpServletRequest, printWriter);
        final boolean sentAnnouncement = announcementSender.sendAnnouncement();

        // BROADCAST SMS
        final MultiChanBroadcastSmsSender smsSender =
                new MultiChanBroadcastSmsSender(serviceData, httpServletRequest, printWriter);
        final boolean sentSms = smsSender.sendSms();

        serviceActivityData.decrement();
        logger.info("MCB : Activity Decrement : " + serviceActivityData.get());

        // If no email, announcement, or sms can be sent, notify it was a bad
        // request.
        if (!sentEmail && !sentAnnouncement && !sentSms)
        {
            httpServletResponse.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
        }
        else
        {
            httpServletResponse.setStatus(HttpServletResponse.SC_OK);
        }
    }

    /**
     * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse
     *      response)
     */
    @Override
    protected void doGet(final HttpServletRequest request, final HttpServletResponse response)
            throws ServletException, IOException
    {
        logger.info("doGet");
        doPost(request, response);
    }
}
