/****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya Inc.
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 * Avaya Confidential & Restricted. May not be distributed further without written permission of
 * the Avaya owner.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.Authorization.TaskDashboard.listener;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;

import com.avaya.collaboration.authorization.client.AuthorizationClientHelper;
import com.avaya.collaboration.ssl.util.SSLUtilityException;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.Authorization.TaskDashboard.provider.EndpointProvider;
import com.avaya.zephyr.services.sample_services.Authorization.TaskDashboard.provider.HttpUtilProvider;
import com.avaya.zephyr.services.sample_services.Authorization.TaskDashboard.provider.ProviderFactory;

/**
 * Listener class to initialize the resources needed for the application.
 * 
 */
@WebListener
public final class ApplicationLifecycleListener implements ServletContextListener
{
    private final HttpUtilProvider httpUtilProvider;
    private final EndpointProvider endpointProvider;
    private final Logger logger;

    public ApplicationLifecycleListener()
    {
        this(ProviderFactory.INSTANCE.getHttpUtilProvider(), ProviderFactory.INSTANCE.getEndpointProvider(), Logger
                .getLogger(ApplicationLifecycleListener.class));
    }

    ApplicationLifecycleListener(final HttpUtilProvider httpUtilProvider,
            final EndpointProvider endpointProvider, final Logger logger)
    {
        this.httpUtilProvider = httpUtilProvider;
        this.endpointProvider = endpointProvider;
        this.logger = logger;
    }

    @Override
    public void contextInitialized(final ServletContextEvent servletContextEvent)
    {
        logger.finer("InitializeListener contextInitialized : Event received for context initialization");
        endpointProvider.buildResourceEndpoint();
        try
        {
            httpUtilProvider.buildHttpClient();
        }
        catch (final SSLUtilityException e)
        {
            logger.error("error building http client" + e);
        }
    }

    @Override
    public void contextDestroyed(final ServletContextEvent servletContextEvent)
    {
        logger.finer("InitializeListener contextDestroyed : Event received for destroying context");
        httpUtilProvider.closeHttpClient();
        AuthorizationClientHelper.shutdown();
    }
}
