/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.CallableService.menus;

import java.util.UUID;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.media.DigitCollectorOperationCause;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.CallableService.PromptsToPlay;
import com.avaya.zephyr.services.sample_services.CallableService.operations.PlayAnnouncementOperation;
import com.avaya.zephyr.services.sample_services.CallableService.operations.PlayAnnouncementOperationImpl;
import com.avaya.zephyr.services.sample_services.CallableService.operations.PromptAndCollectOperation;
import com.avaya.zephyr.services.sample_services.CallableService.operations.PromptAndCollectOperationImpl;

public final class CallableServiceSubMenuMediaListener extends CallableServiceMainMenuMediaListener
{
    private static final String APPROVE_RECORDING = "1";
    private static final String DISCARD_RECORDING = "2";
    private static final String EXIT_APP = "*";

    private final Call call;
    private final PlayAnnouncementOperation playAnnouncementOperation;
    private final PromptAndCollectOperation promptAndCollectOperation;
    private final Logger logger;

    public CallableServiceSubMenuMediaListener(final Call call)
    {
        this(call, Logger.getLogger(CallableServiceSubMenuMediaListener.class));
    }

    public CallableServiceSubMenuMediaListener(final Call call, final Logger logger)
    {
        this(call, new PlayAnnouncementOperationImpl(),
                new PromptAndCollectOperationImpl(), logger);
    }

    CallableServiceSubMenuMediaListener(final Call call,
            final PlayAnnouncementOperation playAnnouncementOperation,
            final PromptAndCollectOperation promptAndCollectOperation, final Logger logger)
    {
        super(call, playAnnouncementOperation, promptAndCollectOperation,
        		null, logger);
        this.call = call;
        this.playAnnouncementOperation = playAnnouncementOperation;
        this.promptAndCollectOperation = promptAndCollectOperation;
        this.logger = logger;
    }

    @Override
    public void digitsCollected(final UUID requestId, final String digits,
            final DigitCollectorOperationCause cause)
    {
        if (logger.isFinerEnabled())
        {
            logger.finer("CallableServiceSubMenuMediaListener digitsCollected ENTER digit: " + digits +
                    ", cause: " + cause.name());
        }

        try
        {
            switch (digits)
            {
                case APPROVE_RECORDING:
                    final Object nextPrompt = call.getAttribute("nextPrompt");

                    if (((PromptsToPlay) nextPrompt).equals(PromptsToPlay.MAINMENU))
                    {
                        logger.finer("CallableServiceSubMenuMediaListener digitsCollected nextPrompt is MAINMENU");
                        promptAndCollectOperation.executePromptAndCollectOperation(call,
                                PromptsToPlay.MAINMENU);
                    }
                    else
                    {
                        logger.info("CallableServiceSubMenuMediaListener digitsCollected approve the recording.");
                        saveRecording(call);
                    }
                    break;
                case DISCARD_RECORDING:
                    logger.info("CallableServiceSubMenuMediaListener digitsCollected discard the recording.");
                    super.setUpRecording();
                    break;
                case EXIT_APP:
                    logger.info("CallableServiceSubMenuMediaListener digitsCollected request to exit.");
                    super.playThankYou(call);
                    break;
                default:
                    logger.error("CallableServiceSubMenuMediaListener digitsCollected: invalid digit=" +
                            digits);
                    // Go back to the main menu if invalid digit is entered or
                    // timeout
                    promptAndCollectOperation.executePromptAndCollectOperation(call,
                            PromptsToPlay.MAINMENU);
                    break;
            }
        }
        catch (final Exception e)
        {
            logger.error("CallableServiceSubMenuMediaListener digitsCollected: failed operation exception=",
                    e);
            call.drop();
        }
        logger.finer("CallableServiceSubMenuMediaListener digitsCollected EXIT ");
    }

    private void saveRecording(final Call call)
    {
        logger.finest("CallableServiceSubMenuMediaListener saveRecording setting nextPrompt to RETURN_TO_MAINMENU");
        call.setAttribute("nextPrompt", PromptsToPlay.RETURN_TO_MAINMENU);
        playAnnouncementOperation.executePlayAnnouncementOperation(call, PromptsToPlay.RECORDING_SAVED);
    }
}
