/*****************************************************************************
 * Â© 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.ClickToCall;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import org.junit.Before;
import org.junit.Test;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.util.logger.Logger;

public final class ClickToCallListenerTest
{
    private static final String DOMAIN = "avaya.com";
    private static final String FIRST_PARTY = "3403@avaya.com";
    private static final String SECOND_PARTY = "3404@avaya.com";
    private Call call;
    private Participant firstParty, secondParty, alertingParty;
    private ClickToCallListener clickToCallListener;
    private Logger logger;

    @Before
    public void setUp()
    {
        call = mock(Call.class);
        firstParty = mock(Participant.class);
        secondParty = mock(Participant.class);
        alertingParty = mock(Participant.class);
        logger = mock(Logger.class);
        clickToCallListener = new ClickToCallListener();

        when(firstParty.getHandle()).thenReturn("3403");
        when(firstParty.getDomain()).thenReturn(DOMAIN);
        when(firstParty.getAddress()).thenReturn(FIRST_PARTY);
        when(secondParty.getHandle()).thenReturn("3404");
        when(secondParty.getDomain()).thenReturn(DOMAIN);
        when(secondParty.getAddress()).thenReturn(SECOND_PARTY);
        when(call.getCallingParty()).thenReturn(firstParty);
        when(call.getCalledParty()).thenReturn(secondParty);
    }

    @Test
    public void callOriginated_successful()
    {
        when(logger.isFinestEnabled()).thenReturn(true);
        when(call.getCallingParty().getAddress()).thenReturn(FIRST_PARTY);
        clickToCallListener.callOriginated(call);

        assertEquals(firstParty.getAddress(), call.getCallingParty()
                .getAddress());
    }

    @Test
    public void callAnswered_successful()
    {
        when(logger.isFinestEnabled()).thenReturn(true);
        when(call.getCalledParty().getAddress()).thenReturn(SECOND_PARTY);
        clickToCallListener.callAnswered(call);

        assertEquals(secondParty.getAddress(), call.getCalledParty()
                .getAddress());
    }

    @Test
    public void callAlerting_successful()
    {
        when(logger.isFinestEnabled()).thenReturn(true);
        when(alertingParty.getAddress()).thenReturn(FIRST_PARTY);
        clickToCallListener.callAlerting(alertingParty);

        assertEquals(firstParty.getAddress(), alertingParty.getAddress());
    }
}
