/****************************************************************************
* Copyright Avaya Inc., All Rights Reserved.
* THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
* The copyright notice above does not evidence any actual or intended publication of such source code.
* Some third-party source code components may have been modified from their original versions by Avaya Inc.
* The modifications are Copyright Avaya Inc., All Rights Reserved.
* Avaya Confidential & Restricted. May not be distributed further without written permission of
* the Avaya owner.
****************************************************************************/
package com.avaya.zephyr.services.sample_services.Authorization.TaskDashboard.provider;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.mockito.Mockito.verifyZeroInteractions;
import static org.mockito.Mockito.when;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;

import javax.net.ssl.SSLContext;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import com.avaya.collaboration.ssl.util.SSLUtilityException;
import com.avaya.collaboration.util.logger.Logger;

@RunWith(MockitoJUnitRunner.class)
public class HttpUtilProviderImplTest
{
    HttpUtilProvider httpUtilProvider;
    @Mock
    HttpGet mockHttpGet;
    @Mock
    HttpResponse mockHttpResponse;
    @Mock
    HttpEntity mockHttpEntity;
    @Mock
    InputStream mockInputStream;
    @Mock
    EndpointProvider endpointProvider;
    @Mock
    Logger mockLogger;
    SSLContext sslContext;

    @Before
    public void before() throws NoSuchAlgorithmException
    {
        sslContext = SSLContext.getDefault();
        httpUtilProvider = new HttpUtilProviderImpl(endpointProvider, sslContext, mockLogger);
    }

    @After
    public void after()
    {
        httpUtilProvider.closeHttpClient();
    }

    @Test
    public void buildHttpClient_build_success() throws SSLUtilityException
    {
        httpUtilProvider.buildHttpClient();
        
        assertNotNull(httpUtilProvider.getHttpClient());
    }

    @Test
    public void closeHttpClient_close_success() throws Exception
    {
        httpUtilProvider.buildHttpClient();
        httpUtilProvider.closeHttpClient();
        
        verifyZeroInteractions(mockLogger);
    }

    @Test
    public void createHttpGet_httpGetForToken_notNull()
    {
        String url = "resourceURL";
        when(endpointProvider.getResourceEndpoint()).thenReturn(url);
        assertNotNull(httpUtilProvider.createHttpGet("accessToken"));
    }

    @Test
    public void getHttpResponseAsString_stringFromHttpResponse_success()
            throws Exception
    {
        final String exampleString = "exampleString";
        final InputStream stream = new ByteArrayInputStream(exampleString.getBytes(StandardCharsets.UTF_8));
        when(mockHttpResponse.getEntity()).thenReturn(mockHttpEntity);
        when(mockHttpEntity.getContent()).thenReturn(stream);
        
        assertEquals(exampleString, httpUtilProvider.getHttpResponseAsString(mockHttpResponse));
    }

    @Test
    public void getHttpResponseAsString_stringFromHttpResponse_exception() throws Exception
    {
        when(mockHttpResponse.getEntity()).thenReturn(mockHttpEntity);
        when(mockHttpEntity.getContent()).thenReturn(mockInputStream);
        assertNull(httpUtilProvider.getHttpResponseAsString(mockHttpResponse));
    }
}
