/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.media.PlayOperationCause;
import com.avaya.collaboration.util.logger.Logger;

@RunWith(PowerMockRunner.class)
public final class CallDeflectionMediaListenerTest
{
    @Mock
    private Call call;
    @Mock
    private Logger logger;
    @Mock
    private CallDeflectionOperations operation;

    @Mock
    private CallDeflectionMediaOperations mediaOperation;
    CallDeflectionMediaListener callDeflectionMediaListener;

    @Before
    public void setup()
    {
        when(logger.isFinerEnabled()).thenReturn(true);
        when(logger.isFinestEnabled()).thenReturn(true);
        callDeflectionMediaListener = new CallDeflectionMediaListener(call, operation, mediaOperation, logger);

    }

    @Test
    public void dial()
    {
        callDeflectionMediaListener.digitsCollected(null, CallDeflectionMediaListener.DIGIT3, null);
        verify(operation).addPartyToCall(call);
    }

    @Test
    public void sendMail()
    {
        when(mediaOperation.getPromptNumber()).thenReturn(2);
        callDeflectionMediaListener.digitsCollected(null, CallDeflectionMediaListener.DIGIT2, null);
        when(mediaOperation.getPromptNumber()).thenReturn(4);
        callDeflectionMediaListener.playCompleted(null, PlayOperationCause.COMPLETE);
        verify(operation).sendEmail();
    }

    @Test
    public void sendSms()
    {
        when(mediaOperation.getPromptNumber()).thenReturn(1);
        callDeflectionMediaListener.digitsCollected(null, CallDeflectionMediaListener.DIGIT1, null);
        when(mediaOperation.getPromptNumber()).thenReturn(3);
        callDeflectionMediaListener.playCompleted(null, PlayOperationCause.COMPLETE);
        verify(operation).sendSms(call);
    }

    @Test
    public void dropCall()
    {
        callDeflectionMediaListener.digitsCollected(null, null, null);
        verify(operation).dropCall(call);
    }
}
